/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TestingOperatorContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOperatorMemoryRevocation {
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testOperatorMemoryRevocation() {
        AtomicInteger counter = new AtomicInteger();
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        LocalMemoryContext revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        revocableMemoryContext.setBytes(1000L);
        operatorContext.setMemoryRevocationRequestListener(() -> counter.incrementAndGet());
        operatorContext.requestMemoryRevoking();
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
        Assert.assertEquals((int)counter.get(), (int)1);
        operatorContext.resetMemoryRevokingRequested();
        Assert.assertFalse((boolean)operatorContext.isMemoryRevokingRequested());
        operatorContext.requestMemoryRevoking();
        Assert.assertEquals((int)counter.get(), (int)2);
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
    }

    @Test
    public void testRevocationAlreadyRequested() {
        AtomicInteger counter = new AtomicInteger();
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        LocalMemoryContext revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        revocableMemoryContext.setBytes(1000L);
        operatorContext.requestMemoryRevoking();
        operatorContext.setMemoryRevocationRequestListener(() -> counter.incrementAndGet());
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
        Assert.assertEquals((int)counter.get(), (int)1);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="listener already set")
    public void testSingleListenerEnforcement() {
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        operatorContext.setMemoryRevocationRequestListener(() -> {});
        operatorContext.setMemoryRevocationRequestListener(() -> {});
    }
}

