/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.spi.plan.PlanNodeId;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperatorStats {
    private static final SplitOperatorInfo NON_MERGEABLE_INFO = new SplitOperatorInfo((Object)"some_info");
    private static final PartitionedOutputInfo MERGEABLE_INFO = new PartitionedOutputInfo(1L, 2L, 1024L);
    public static final OperatorStats EXPECTED = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(123.0, DataSize.Unit.BYTE), new DataSize(5.0, DataSize.Unit.BYTE), 10L, new DataSize(6.0, DataSize.Unit.BYTE), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), new DataSize(12.0, DataSize.Unit.BYTE), 13L, new DataSize(14.0, DataSize.Unit.BYTE), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), new DataSize(345.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), new DataSize(23.0, DataSize.Unit.BYTE), new DataSize(24.0, DataSize.Unit.BYTE), new DataSize(25.0, DataSize.Unit.BYTE), Optional.empty(), (OperatorInfo)NON_MERGEABLE_INFO);
    public static final OperatorStats MERGEABLE = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(123.0, DataSize.Unit.BYTE), new DataSize(5.0, DataSize.Unit.BYTE), 10L, new DataSize(6.0, DataSize.Unit.BYTE), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), new DataSize(12.0, DataSize.Unit.BYTE), 13L, new DataSize(14.0, DataSize.Unit.BYTE), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), new DataSize(345.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), new DataSize(23.0, DataSize.Unit.BYTE), new DataSize(24.0, DataSize.Unit.BYTE), new DataSize(25.0, DataSize.Unit.BYTE), Optional.empty(), (OperatorInfo)MERGEABLE_INFO);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)EXPECTED);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)1L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)2L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(123.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(5.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(6.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)7L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)8.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)9L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(234.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(12.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)13L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(14.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)16L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(345.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(19.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(21.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(25.0, DataSize.Unit.BYTE));
        Assert.assertEquals(actual.getInfo().getClass(), SplitOperatorInfo.class);
        Assert.assertEquals((Object)((SplitOperatorInfo)actual.getInfo()).getSplitInfo(), (Object)NON_MERGEABLE_INFO.getSplitInfo());
    }

    @Test
    public void testAdd() {
        OperatorStats actual = EXPECTED.add(new OperatorStats[]{EXPECTED, EXPECTED});
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(369.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(702.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(36.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(42.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(1035.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(57.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(60.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(63.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(75.0, DataSize.Unit.BYTE));
        Assert.assertNull((Object)actual.getInfo());
    }

    @Test
    public void testAddMergeable() {
        OperatorStats actual = MERGEABLE.add(new OperatorStats[]{MERGEABLE, MERGEABLE});
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputAllocation(), (Object)new DataSize(369.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputAllocation(), (Object)new DataSize(702.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(36.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(42.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishAllocation(), (Object)new DataSize(1035.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(57.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(60.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(63.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakSystemMemoryReservation(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(75.0, DataSize.Unit.BYTE));
        Assert.assertEquals(actual.getInfo().getClass(), PartitionedOutputInfo.class);
        Assert.assertEquals((long)((PartitionedOutputInfo)actual.getInfo()).getPagesAdded(), (long)(3L * MERGEABLE_INFO.getPagesAdded()));
    }
}

