/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.ArrayPositionLinks;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.operator.SimplePagesHashStrategy;
import com.facebook.presto.operator.SortedPositionLinks;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPositionLinks {
    private static final Page TEST_PAGE = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(20, 0).build());

    @Test
    public void testArrayPositionLinks() {
        ArrayPositionLinks.FactoryBuilder factoryBuilder = ArrayPositionLinks.builder((int)1000);
        Assert.assertEquals((int)factoryBuilder.link(1, 0), (int)1);
        Assert.assertEquals((int)factoryBuilder.link(2, 1), (int)2);
        Assert.assertEquals((int)factoryBuilder.link(3, 2), (int)3);
        Assert.assertEquals((int)factoryBuilder.link(11, 10), (int)11);
        Assert.assertEquals((int)factoryBuilder.link(12, 11), (int)12);
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of());
        Assert.assertEquals((int)positionLinks.start(3, 0, TEST_PAGE), (int)3);
        Assert.assertEquals((int)positionLinks.next(3, 0, TEST_PAGE), (int)2);
        Assert.assertEquals((int)positionLinks.next(2, 0, TEST_PAGE), (int)1);
        Assert.assertEquals((int)positionLinks.next(1, 0, TEST_PAGE), (int)0);
        Assert.assertEquals((int)positionLinks.start(4, 0, TEST_PAGE), (int)4);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(12, 0, TEST_PAGE), (int)12);
        Assert.assertEquals((int)positionLinks.next(12, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)10);
    }

    @Test
    public void testSortedPositionLinks() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) > 4L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)12);
        Assert.assertEquals((int)positionLinks.next(12, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)13);
        Assert.assertEquals((int)positionLinks.next(13, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testSortedPositionLinksAllMatch() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) >= 0L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)0);
        Assert.assertEquals((int)positionLinks.next(0, 0, TEST_PAGE), (int)1);
        Assert.assertEquals((int)positionLinks.next(1, 0, TEST_PAGE), (int)2);
        Assert.assertEquals((int)positionLinks.next(2, 0, TEST_PAGE), (int)3);
        Assert.assertEquals((int)positionLinks.next(3, 0, TEST_PAGE), (int)4);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)12);
        Assert.assertEquals((int)positionLinks.next(12, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)13);
        Assert.assertEquals((int)positionLinks.next(13, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicates() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) > 4L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) <= 11L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicatesPrefixMatch() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) >= 0L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) <= 11L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)0);
        Assert.assertEquals((int)positionLinks.next(0, 0, TEST_PAGE), (int)1);
        Assert.assertEquals((int)positionLinks.next(1, 0, TEST_PAGE), (int)2);
        Assert.assertEquals((int)positionLinks.next(2, 0, TEST_PAGE), (int)3);
        Assert.assertEquals((int)positionLinks.next(3, 0, TEST_PAGE), (int)4);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicatesSuffixMatch() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) > 4L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) < 100L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)12);
        Assert.assertEquals((int)positionLinks.next(12, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)13);
        Assert.assertEquals((int)positionLinks.next(13, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testReverseSortedPositionLinks() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) < 4L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)0);
        Assert.assertEquals((int)positionLinks.next(0, 0, TEST_PAGE), (int)1);
        Assert.assertEquals((int)positionLinks.next(1, 0, TEST_PAGE), (int)2);
        Assert.assertEquals((int)positionLinks.next(2, 0, TEST_PAGE), (int)3);
        Assert.assertEquals((int)positionLinks.next(3, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)-1);
    }

    @Test
    public void testReverseSortedPositionLinksAllMatch() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) < 13L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assert.assertEquals((int)positionLinks.start(0, 0, TEST_PAGE), (int)0);
        Assert.assertEquals((int)positionLinks.next(0, 0, TEST_PAGE), (int)1);
        Assert.assertEquals((int)positionLinks.next(1, 0, TEST_PAGE), (int)2);
        Assert.assertEquals((int)positionLinks.next(2, 0, TEST_PAGE), (int)3);
        Assert.assertEquals((int)positionLinks.next(3, 0, TEST_PAGE), (int)4);
        Assert.assertEquals((int)positionLinks.next(4, 0, TEST_PAGE), (int)5);
        Assert.assertEquals((int)positionLinks.next(5, 0, TEST_PAGE), (int)6);
        Assert.assertEquals((int)positionLinks.next(6, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(7, 0, TEST_PAGE), (int)7);
        Assert.assertEquals((int)positionLinks.next(7, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(8, 0, TEST_PAGE), (int)8);
        Assert.assertEquals((int)positionLinks.next(8, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(9, 0, TEST_PAGE), (int)9);
        Assert.assertEquals((int)positionLinks.next(9, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(10, 0, TEST_PAGE), (int)10);
        Assert.assertEquals((int)positionLinks.next(10, 0, TEST_PAGE), (int)11);
        Assert.assertEquals((int)positionLinks.next(11, 0, TEST_PAGE), (int)12);
        Assert.assertEquals((int)positionLinks.next(12, 0, TEST_PAGE), (int)-1);
        Assert.assertEquals((int)positionLinks.start(13, 0, TEST_PAGE), (int)-1);
    }

    private static PositionLinks.FactoryBuilder buildSortedPositionLinks() {
        SortedPositionLinks.FactoryBuilder builder = SortedPositionLinks.builder((int)1000, (PagesHashStrategy)TestPositionLinks.pagesHashStrategy(), (LongArrayList)TestPositionLinks.addresses());
        Assert.assertEquals((int)builder.link(4, 5), (int)4);
        Assert.assertEquals((int)builder.link(6, 4), (int)4);
        Assert.assertEquals((int)builder.link(2, 4), (int)2);
        Assert.assertEquals((int)builder.link(3, 2), (int)2);
        Assert.assertEquals((int)builder.link(0, 2), (int)0);
        Assert.assertEquals((int)builder.link(1, 0), (int)0);
        Assert.assertEquals((int)builder.link(10, 11), (int)10);
        Assert.assertEquals((int)builder.link(12, 10), (int)10);
        return builder;
    }

    private static PagesHashStrategy pagesHashStrategy() {
        return new SimplePagesHashStrategy((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of(), (List)ImmutableList.of((Object)ImmutableList.of((Object)TEST_PAGE.getBlock(0))), (List)ImmutableList.of(), OptionalInt.empty(), Optional.of(0), MetadataManager.createTestMetadataManager().getFunctionAndTypeManager(), new FeaturesConfig().isGroupByUsesEqualTo());
    }

    private static LongArrayList addresses() {
        LongArrayList addresses = new LongArrayList();
        for (int i = 0; i < TEST_PAGE.getPositionCount(); ++i) {
            addresses.add(SyntheticAddress.encodeSyntheticAddress((int)0, (int)i));
        }
        return addresses;
    }
}

