/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskMetadataContext;
import com.facebook.presto.execution.scheduler.ExecutionWriterTarget;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.metadata.ConnectorMetadataUpdaterManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DevNullOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PageSinkCommitStrategy;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTableWriterOperator {
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("testConnectorId");
    private static final JsonCodec<TableCommitContext> TABLE_COMMIT_CONTEXT_CODEC = JsonCodec.jsonCodec(TableCommitContext.class);
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testBlockedPageSink() {
        BlockingPageSink blockingPageSink = new BlockingPageSink();
        Operator operator = this.createTableWriterOperator(blockingPageSink);
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertNull((Object)operator.getOutput());
        blockingPageSink.complete();
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(44).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        blockingPageSink.complete();
        ImmutableList expectedTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY);
        PageAssertions.assertPageEquals((List<? extends Type>)expectedTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)expectedTypes).row(2, null, TestTableWriterOperator.getTableCommitContext(true)).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void addInputFailsOnBlockedOperator() {
        Operator operator = this.createTableWriterOperator(new BlockingPageSink());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
    }

    @Test
    public void testTableWriterInfo() {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(new TableWriteInfoTestPageSink()));
        TableWriterOperator tableWriterOperator = (TableWriterOperator)this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new DevNullOperator.DevNullOperatorFactory(1, new PlanNodeId("test")), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY));
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT});
        for (int i = 0; i < 100; ++i) {
            rowPagesBuilder.addSequencePage(100, 0);
        }
        List<Page> pages = rowPagesBuilder.build();
        long peakMemoryUsage = 0L;
        long validationCpuNanos = 0L;
        for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            tableWriterOperator.addInput(page);
            TableWriterOperator.TableWriterInfo info = tableWriterOperator.getInfo();
            Assert.assertEquals((long)info.getPageSinkPeakMemoryUsage(), (long)(peakMemoryUsage += page.getRetainedSizeInBytes()));
            Assert.assertEquals((long)((long)info.getValidationCpuTime().getValue(TimeUnit.NANOSECONDS)), (long)(validationCpuNanos += (long)page.getPositionCount()));
        }
    }

    @Test
    public void testStatisticsAggregation() throws Exception {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(new TableWriteInfoTestPageSink()));
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        Session session = TestingSession.testSessionBuilder().setSystemProperty("statistics_cpu_timer_enabled", "true").build();
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        TaskMetadataContext taskMetadataContext = taskContext.getTaskMetadataContext();
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        InternalAggregationFunction longMaxFunction = functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        TableWriterOperator operator = (TableWriterOperator)this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)longMaxFunction.bind((List)ImmutableList.of((Object)0), Optional.empty())), true), (List<Type>)outputTypes, session, taskMetadataContext, driverContext);
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(43).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.needsInput());
        Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished());
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(null, null, TestTableWriterOperator.getTableCommitContext(false), 43).build().get(0));
        BlockBuilder rowsBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder fragmentsBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        rowsBuilder.writeLong(1L);
        fragmentsBuilder.appendNull();
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(2, null, TestTableWriterOperator.getTableCommitContext(true), null).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertTrue((boolean)operator.isFinished());
        operator.close();
        this.assertMemoryIsReleased(operator);
        TableWriterOperator.TableWriterInfo info = operator.getInfo();
        Assertions.assertThat((double)info.getStatisticsWallTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assertions.assertThat((double)info.getStatisticsCpuTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
    }

    private static Slice getTableCommitContext(boolean lastPage) {
        return Slices.wrappedBuffer((byte[])TABLE_COMMIT_CONTEXT_CODEC.toJsonBytes((Object)new TableCommitContext(Lifespan.taskWide(), new TaskId("query", 0, 0, 0), PageSinkCommitStrategy.NO_COMMIT, lastPage)));
    }

    private void assertMemoryIsReleased(TableWriterOperator tableWriterOperator) {
        OperatorContext tableWriterOperatorOperatorContext = tableWriterOperator.getOperatorContext();
        MemoryTrackingContext tableWriterMemoryContext = tableWriterOperatorOperatorContext.getOperatorMemoryContext();
        Assert.assertEquals((long)tableWriterMemoryContext.getSystemMemory(), (long)0L);
        Assert.assertEquals((long)tableWriterMemoryContext.getUserMemory(), (long)0L);
        Assert.assertEquals((long)tableWriterMemoryContext.getRevocableMemory(), (long)0L);
        Operator statisticAggregationOperator = tableWriterOperator.getStatisticAggregationOperator();
        Assert.assertTrue((boolean)(statisticAggregationOperator instanceof AggregationOperator));
        AggregationOperator aggregationOperator = (AggregationOperator)statisticAggregationOperator;
        OperatorContext aggregationOperatorOperatorContext = aggregationOperator.getOperatorContext();
        MemoryTrackingContext aggregationOperatorMemoryContext = aggregationOperatorOperatorContext.getOperatorMemoryContext();
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getSystemMemory(), (long)0L);
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getUserMemory(), (long)0L);
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getRevocableMemory(), (long)0L);
    }

    private Operator createTableWriterOperator(BlockingPageSink blockingPageSink) {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(blockingPageSink));
        return this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new DevNullOperator.DevNullOperatorFactory(1, new PlanNodeId("test")), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY));
    }

    private Operator createTableWriterOperator(PageSinkManager pageSinkManager, OperatorFactory statisticsAggregation, List<Type> outputTypes) {
        return this.createTableWriterOperator(pageSinkManager, statisticsAggregation, outputTypes, SessionTestUtils.TEST_SESSION);
    }

    private Operator createTableWriterOperator(PageSinkManager pageSinkManager, OperatorFactory statisticsAggregation, List<Type> outputTypes, Session session) {
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        TaskMetadataContext taskMetadataContext = taskContext.getTaskMetadataContext();
        return this.createTableWriterOperator(pageSinkManager, statisticsAggregation, outputTypes, session, taskMetadataContext, driverContext);
    }

    private Operator createTableWriterOperator(PageSinkManager pageSinkManager, OperatorFactory statisticsAggregation, List<Type> outputTypes, Session session, TaskMetadataContext taskMetadataContext, DriverContext driverContext) {
        TableWriterOperator.TableWriterOperatorFactory factory = new TableWriterOperator.TableWriterOperatorFactory(0, new PlanNodeId("test"), pageSinkManager, new ConnectorMetadataUpdaterManager(), taskMetadataContext, (ExecutionWriterTarget)new ExecutionWriterTarget.CreateHandle(new OutputTableHandle(CONNECTOR_ID, new ConnectorTransactionHandle(){}, new ConnectorOutputTableHandle(){}), new SchemaTableName("testSchema", "testTable")), (List)ImmutableList.of((Object)0), session, statisticsAggregation, outputTypes, TABLE_COMMIT_CONTEXT_CODEC, PageSinkCommitStrategy.NO_COMMIT);
        return factory.createOperator(driverContext);
    }

    private static class TableWriteInfoTestPageSink
    implements ConnectorPageSink {
        private final List<Page> pages = new ArrayList<Page>();

        private TableWriteInfoTestPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.pages.add(page);
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }

        public long getSystemMemoryUsage() {
            long memoryUsage = 0L;
            for (Page page : this.pages) {
                memoryUsage += page.getRetainedSizeInBytes();
            }
            return memoryUsage;
        }

        public long getValidationCpuNanos() {
            long validationCpuNanos = 0L;
            for (Page page : this.pages) {
                validationCpuNanos += (long)page.getPositionCount();
            }
            return validationCpuNanos;
        }

        public void abort() {
        }
    }

    private static class BlockingPageSink
    implements ConnectorPageSink {
        private CompletableFuture<?> future = new CompletableFuture();
        private CompletableFuture<Collection<Slice>> finishFuture = new CompletableFuture();

        private BlockingPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.future = new CompletableFuture();
            return this.future;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            this.finishFuture = new CompletableFuture();
            return this.finishFuture;
        }

        public void abort() {
        }

        void complete() {
            this.future.complete(null);
            this.finishFuture.complete((Collection<Slice>)ImmutableList.of());
        }
    }

    private static class ConstantPageSinkProvider
    implements ConnectorPageSinkProvider {
        private final ConnectorPageSink pageSink;

        private ConstantPageSinkProvider(ConnectorPageSink pageSink) {
            this.pageSink = pageSink;
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
            return this.pageSink;
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
            return this.pageSink;
        }
    }
}

