/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestAggregationFunction {
    protected FunctionAndTypeManager functionAndTypeManager;
    protected Session session;

    protected AbstractTestAggregationFunction() {
        this(TestingSession.testSessionBuilder().build());
    }

    protected AbstractTestAggregationFunction(Session session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @BeforeClass
    public final void initTestAggregationFunction() {
        this.functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    }

    @AfterClass(alwaysRun=true)
    public final void destroyTestAggregationFunction() {
        this.functionAndTypeManager = null;
    }

    public abstract Block[] getSequenceBlocks(int var1, int var2);

    protected void registerFunctions(Plugin plugin) {
        this.functionAndTypeManager.registerBuiltInFunctions(FunctionExtractor.extractFunctions((Collection)plugin.getFunctions()));
    }

    protected void registerTypes(Plugin plugin) {
        for (Type type : plugin.getTypes()) {
            this.functionAndTypeManager.addType(type);
        }
    }

    protected final InternalAggregationFunction getFunction() {
        List parameterTypes = TypeSignatureProvider.fromTypeSignatures((List)Lists.transform(this.getFunctionParameterTypes(), TypeSignature::parseTypeSignature));
        FunctionHandle functionHandle = this.functionAndTypeManager.resolveFunction(this.session.getTransactionId(), FunctionAndTypeManager.qualifyFunctionName((QualifiedName)QualifiedName.of((String)this.getFunctionName())), parameterTypes);
        return this.functionAndTypeManager.getAggregateFunctionImplementation(functionHandle);
    }

    protected abstract String getFunctionName();

    protected abstract List<String> getFunctionParameterTypes();

    public abstract Object getExpectedValue(int var1, int var2);

    public Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return this.getExpectedValue(start, length);
    }

    @Test
    public void testNoPositions() {
        this.testAggregation(this.getExpectedValue(0, 0), this.getSequenceBlocks(0, 0));
    }

    @Test
    public void testSinglePosition() {
        this.testAggregation(this.getExpectedValue(0, 1), this.getSequenceBlocks(0, 1));
    }

    @Test
    public void testMultiplePositions() {
        this.testAggregation(this.getExpectedValue(0, 5), this.getSequenceBlocks(0, 5));
    }

    @Test
    public void testAllPositionsNull() {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block[] blocks = new Block[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            blocks[i] = RunLengthEncodedBlock.create((Type)((Type)parameterTypes.get(0)), null, (int)10);
        }
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 0, 10), blocks);
    }

    @Test
    public void testMixedNullAndNonNullPositions() {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block[] alternatingNullsBlocks = this.createAlternatingNullsBlock(parameterTypes, this.getSequenceBlocks(0, 10));
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 10, 20), alternatingNullsBlocks);
    }

    @Test
    public void testNegativeOnlyValues() {
        this.testAggregation(this.getExpectedValue(-10, 5), this.getSequenceBlocks(-10, 5));
    }

    @Test
    public void testPositiveOnlyValues() {
        this.testAggregation(this.getExpectedValue(2, 4), this.getSequenceBlocks(2, 4));
    }

    public Block[] createAlternatingNullsBlock(List<Type> types, Block ... sequenceBlocks) {
        Block[] alternatingNullsBlocks = new Block[sequenceBlocks.length];
        for (int i = 0; i < sequenceBlocks.length; ++i) {
            int positionCount = sequenceBlocks[i].getPositionCount();
            Type type = types.get(i);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                blockBuilder.appendNull();
                type.appendTo(sequenceBlocks[i], position, blockBuilder);
            }
            alternatingNullsBlocks[i] = blockBuilder.build();
        }
        return alternatingNullsBlocks;
    }

    protected void testAggregation(Object expectedValue, Block ... blocks) {
        AggregationTestUtils.assertAggregation(this.getFunction(), expectedValue, blocks);
    }
}

