/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.AbstractTestApproximateCountDistinct;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestApproximateCountDistinctBoolean
extends AbstractTestApproximateCountDistinct {
    @Override
    public InternalAggregationFunction getAggregationFunction() {
        return FUNCTION_AND_TYPE_MANAGER.getAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("approx_distinct", TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE})));
    }

    @Override
    public Type getValueType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public Object randomValue() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @DataProvider(name="inputSequences")
    public Object[][] inputSequences() {
        return new Object[][]{{true}, {false}, {true, false}, {true, true, true}, {false, false, false}, {true, false, true, false}};
    }

    @Test(dataProvider="inputSequences")
    public void testNonEmptyInputs(boolean ... inputSequence) {
        List values = Booleans.asList((boolean[])inputSequence);
        this.assertCount(values, 0.0, this.distinctCount(values));
    }

    @Test
    public void testNoInput() {
        this.assertCount((List<?>)ImmutableList.of(), 0.0, 0L);
    }

    private long distinctCount(List<Boolean> inputSequence) {
        return ImmutableSet.copyOf(inputSequence).size();
    }

    @Override
    protected int getUniqueValuesCount() {
        return 2;
    }
}

