/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestBooleanAndAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 == 0);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Boolean getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return length > 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected String getFunctionName() {
        return "bool_and";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"boolean");
    }
}

