/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestDateMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DateType.DATE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DateType.DATE.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDate getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return new SqlDate(start + length - 1);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"date");
    }
}

