/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TDigestParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.operator.aggregation.TestMergeStatisticalDigestFunction;
import com.facebook.presto.tdigest.TDigest;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class TestMergeTDigestFunction
extends TestMergeStatisticalDigestFunction {
    private static final double[] quantiles = new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99};
    public static final BiFunction<Object, Object, Boolean> TDIGEST_EQUALITY = (actualBinary, expectedBinary) -> {
        if (actualBinary == null && expectedBinary == null) {
            return true;
        }
        Objects.requireNonNull(actualBinary, "actual value was null");
        Objects.requireNonNull(expectedBinary, "expected value was null");
        TDigest actual = TDigest.createTDigest((Slice)Slices.wrappedBuffer((byte[])((SqlVarbinary)actualBinary).getBytes()));
        TDigest expected = TDigest.createTDigest((Slice)Slices.wrappedBuffer((byte[])((SqlVarbinary)expectedBinary).getBytes()));
        for (double quantile : quantiles) {
            if (!(Math.abs(actual.getQuantile(quantile) - expected.getQuantile(quantile)) > Math.max(0.5, Math.abs(actual.getQuantile(quantile) * 0.01)))) continue;
            return false;
        }
        return actual.getSize() == expected.getSize() && actual.getMin() == expected.getMin() && actual.getMax() == expected.getMax() && actual.getCompressionFactor() == expected.getCompressionFactor();
    };

    @Override
    protected BiFunction<Object, Object, Boolean> getEquality() {
        return TDIGEST_EQUALITY;
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        Type type = TDigestParametricType.TDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE)));
        BlockBuilder blockBuilder = type.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            TDigest tdigest = TDigest.createTDigest((double)100.0);
            tdigest.add((double)i);
            type.writeSlice(blockBuilder, tdigest.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"tdigest(double)");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        TDigest tdigest = TDigest.createTDigest((double)100.0);
        for (int i = start; i < start + length; ++i) {
            tdigest.add((double)i);
        }
        return new SqlVarbinary(tdigest.serialize().getBytes());
    }
}

