/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.TestMergeQuantileDigestFunction;
import com.facebook.presto.operator.aggregation.TestStatisticalDigestAggregationFunction;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.testng.annotations.Test;

public class TestQuantileDigestAggregationFunction
extends TestStatisticalDigestAggregationFunction {
    private static final double STANDARD_ERROR = 0.01;

    @Override
    protected double getParameter() {
        return 0.01;
    }

    @Test
    public void testRealsWithWeights() {
        this.testAggregationReal(BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), null, Float.valueOf(3.0f), null, Float.valueOf(4.0f), null, Float.valueOf(5.0f), null), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f);
        this.testAggregationReal(BlockAssertions.createBlockOfReals(null, null, null, null, null), (Block)BlockAssertions.createRLEBlock(1L, 5), Double.NaN, new float[0]);
        this.testAggregationReal(BlockAssertions.createBlockOfReals(Float.valueOf(-1.0f), Float.valueOf(-2.0f), Float.valueOf(-3.0f), Float.valueOf(-4.0f), Float.valueOf(-5.0f), Float.valueOf(-6.0f), Float.valueOf(-7.0f), Float.valueOf(-8.0f), Float.valueOf(-9.0f), Float.valueOf(-10.0f)), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, -1.0f, -2.0f, -3.0f, -4.0f, -5.0f, -6.0f, -7.0f, -8.0f, -9.0f, -10.0f);
        this.testAggregationReal(BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f)), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        this.testAggregationReal(BlockAssertions.createBlockOfReals(new Float[0]), (Block)BlockAssertions.createRLEBlock(1L, 0), Double.NaN, new float[0]);
        this.testAggregationReal(BlockAssertions.createBlockOfReals(Float.valueOf(1.0f)), (Block)BlockAssertions.createRLEBlock(1L, 1), 0.01, 1.0f);
        this.testAggregationReal(BlockAssertions.createSequenceBlockOfReal(-1000, 1000), (Block)BlockAssertions.createRLEBlock(1L, 2000), 0.01, Floats.toArray((Collection)((Collection)LongStream.range(-1000L, 1000L).mapToObj(Float::new).collect(ImmutableList.toImmutableList()))));
    }

    @Test
    public void testBigintsWithWeight() {
        this.testAggregationBigint(BlockAssertions.createLongsBlock(1L, null, 2L, null, 3L, null, 4L, null, 5L, null), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, 1L, 2L, 3L, 4L, 5L);
        this.testAggregationBigint(BlockAssertions.createLongsBlock(null, null, null, null, null), (Block)BlockAssertions.createRLEBlock(1L, 5), Double.NaN, new long[0]);
        this.testAggregationBigint(BlockAssertions.createLongsBlock(-1, -2, -3, -4, -5, -6, -7, -8, -9, -10), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, -1L, -2L, -3L, -4L, -5L, -6L, -7L, -8L, -9L, -10L);
        this.testAggregationBigint(BlockAssertions.createLongsBlock(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), (Block)BlockAssertions.createRLEBlock(1L, 10), 0.01, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.testAggregationBigint(BlockAssertions.createLongsBlock(new int[0]), (Block)BlockAssertions.createRLEBlock(1L, 0), Double.NaN, new long[0]);
        this.testAggregationBigint(BlockAssertions.createLongsBlock(1), (Block)BlockAssertions.createRLEBlock(1L, 1), 0.01, 1L);
        this.testAggregationBigint(BlockAssertions.createLongSequenceBlock(-1000, 1000), (Block)BlockAssertions.createRLEBlock(1L, 2000), 0.01, LongStream.range(-1000L, 1000L).toArray());
    }

    @Override
    protected InternalAggregationFunction getAggregationFunction(Type ... type) {
        FunctionAndTypeManager functionAndTypeManager = METADATA.getFunctionAndTypeManager();
        return functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("qdigest_agg", TypeSignatureProvider.fromTypes((Type[])type)));
    }

    private void testAggregationBigint(Block inputBlock, Block weightsBlock, double maxError, long ... inputs) {
        this.testAggregationBigints(this.getAggregationFunction(new Type[]{BigintType.BIGINT}), new Page(new Block[]{inputBlock}), maxError, inputs);
        this.testAggregationBigints(this.getAggregationFunction(new Type[]{BigintType.BIGINT, BigintType.BIGINT}), new Page(new Block[]{inputBlock, weightsBlock}), maxError, inputs);
        this.testAggregationBigints(this.getAggregationFunction(new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE}), new Page(new Block[]{inputBlock, weightsBlock, BlockAssertions.createRLEBlock(maxError, inputBlock.getPositionCount())}), maxError, inputs);
    }

    private void testAggregationReal(Block longsBlock, Block weightsBlock, double maxError, float ... inputs) {
        this.testAggregationReal(this.getAggregationFunction(new Type[]{RealType.REAL}), new Page(new Block[]{longsBlock}), maxError, inputs);
        this.testAggregationReal(this.getAggregationFunction(new Type[]{RealType.REAL, BigintType.BIGINT}), new Page(new Block[]{longsBlock, weightsBlock}), maxError, inputs);
        this.testAggregationReal(this.getAggregationFunction(new Type[]{RealType.REAL, BigintType.BIGINT, DoubleType.DOUBLE}), new Page(new Block[]{longsBlock, weightsBlock, BlockAssertions.createRLEBlock(maxError, longsBlock.getPositionCount())}), maxError, inputs);
    }

    private void testAggregationBigints(InternalAggregationFunction function, Page page, double maxError, long ... inputs) {
        AggregationTestUtils.assertAggregation(function, TestMergeQuantileDigestFunction.QDIGEST_EQUALITY, "test multiple positions", page, this.getExpectedValueLongs(maxError, inputs));
        List rows = Arrays.stream(inputs).sorted().boxed().collect(Collectors.toList());
        SqlVarbinary returned = (SqlVarbinary)AggregationTestUtils.aggregation(function, page);
        this.assertPercentileWithinError("qdigest", "bigint", returned, maxError, rows, 0.1, 0.5, 0.9, 0.99);
    }

    private void testAggregationReal(InternalAggregationFunction function, Page page, double maxError, float ... inputs) {
        AggregationTestUtils.assertAggregation(function, TestMergeQuantileDigestFunction.QDIGEST_EQUALITY, "test multiple positions", page, this.getExpectedValuesFloats(maxError, inputs));
        List rows = Floats.asList((float[])inputs).stream().sorted().map(Float::doubleValue).collect(Collectors.toList());
        SqlVarbinary returned = (SqlVarbinary)AggregationTestUtils.aggregation(function, page);
        this.assertPercentileWithinError("qdigest", "real", returned, maxError, rows, 0.1, 0.5, 0.9, 0.99);
    }

    @Override
    protected void testAggregationDoubles(InternalAggregationFunction function, Page page, double maxError, double ... inputs) {
        AggregationTestUtils.assertAggregation(function, TestMergeQuantileDigestFunction.QDIGEST_EQUALITY, "test multiple positions", page, this.getExpectedValueDoubles(maxError, inputs));
        List rows = Doubles.asList((double[])inputs).stream().sorted().collect(Collectors.toList());
        SqlVarbinary returned = (SqlVarbinary)AggregationTestUtils.aggregation(function, page);
        this.assertPercentileWithinError("qdigest", "double", returned, maxError, rows, 0.1, 0.5, 0.9, 0.99);
    }

    private Object getExpectedValueLongs(double maxError, long ... values) {
        if (values.length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(maxError);
        Arrays.stream(values).forEach(arg_0 -> ((QuantileDigest)qdigest).add(arg_0));
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }

    @Override
    protected Object getExpectedValueDoubles(double maxError, double ... values) {
        if (values.length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(maxError);
        Arrays.stream(values).forEach(value -> qdigest.add(FloatingPointBitsConverterUtil.doubleToSortableLong((double)value)));
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }

    private Object getExpectedValuesFloats(double maxError, float ... values) {
        if (values.length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(maxError);
        Floats.asList((float[])values).forEach(value -> qdigest.add((long)FloatingPointBitsConverterUtil.floatToSortableInt((float)value.floatValue())));
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }
}

