/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.LongStream;
import org.testng.annotations.Test;

public abstract class TestStatisticalDigestAggregationFunction
extends AbstractTestFunctions {
    static final Joiner ARRAY_JOINER = Joiner.on((String)",");
    protected static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testDoublesWithWeights() {
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(1.0, null, 2.0, null, 3.0, null, 4.0, null, 5.0, null), (Block)BlockAssertions.createRLEBlock(1L, 10), this.getParameter(), 1.0, 2.0, 3.0, 4.0, 5.0);
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(null, null, null, null, null), (Block)BlockAssertions.createRLEBlock(1L, 5), Double.NaN, new double[0]);
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(-1.0, -2.0, -3.0, -4.0, -5.0, -6.0, -7.0, -8.0, -9.0, -10.0), (Block)BlockAssertions.createRLEBlock(1L, 10), this.getParameter(), -1.0, -2.0, -3.0, -4.0, -5.0, -6.0, -7.0, -8.0, -9.0, -10.0);
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0), (Block)BlockAssertions.createRLEBlock(1L, 10), this.getParameter(), 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(new Double[0]), (Block)BlockAssertions.createRLEBlock(1L, 0), Double.NaN, new double[0]);
        this.testAggregationDouble(BlockAssertions.createDoublesBlock(1.0), (Block)BlockAssertions.createRLEBlock(1L, 1), this.getParameter(), 1.0);
        this.testAggregationDouble(BlockAssertions.createDoubleSequenceBlock(-1000, 1000), (Block)BlockAssertions.createRLEBlock(1L, 2000), this.getParameter(), LongStream.range(-1000L, 1000L).asDoubleStream().toArray());
    }

    protected abstract InternalAggregationFunction getAggregationFunction(Type ... var1);

    private void testAggregationDouble(Block longsBlock, Block weightsBlock, double parameter, double ... inputs) {
        this.testAggregationDoubles(this.getAggregationFunction(new Type[]{DoubleType.DOUBLE}), new Page(new Block[]{longsBlock}), parameter, inputs);
        this.testAggregationDoubles(this.getAggregationFunction(new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}), new Page(new Block[]{longsBlock, weightsBlock}), parameter, inputs);
        this.testAggregationDoubles(this.getAggregationFunction(new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}), new Page(new Block[]{longsBlock, weightsBlock, BlockAssertions.createRLEBlock(parameter, longsBlock.getPositionCount())}), parameter, inputs);
    }

    abstract double getParameter();

    abstract void testAggregationDoubles(InternalAggregationFunction var1, Page var2, double var3, double ... var5);

    abstract Object getExpectedValueDoubles(double var1, double ... var3);

    void assertPercentileWithinError(String method, String type, SqlVarbinary binary, double error, List<? extends Number> rows, double ... percentiles) {
        if (rows.isEmpty()) {
            return;
        }
        for (double percentile : percentiles) {
            this.assertPercentileWithinError(method, type, binary, error, rows, percentile);
        }
        this.assertPercentilesWithinError(method, type, binary, error, rows, percentiles);
    }

    private void assertPercentileWithinError(String method, String type, SqlVarbinary binary, double error, List<? extends Number> rows, double percentile) {
        Number lowerBound = this.getLowerBoundValue(error, rows, percentile);
        Number upperBound = this.getUpperBoundValue(error, rows, percentile);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS %s(%s)), %s) >= %s", binary.toString().replaceAll("\\s+", " "), method, type, percentile, lowerBound), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS %s(%s)), %s) <= %s", binary.toString().replaceAll("\\s+", " "), method, type, percentile, upperBound), (Type)BooleanType.BOOLEAN, true);
    }

    private void assertPercentilesWithinError(String method, String type, SqlVarbinary binary, double error, List<? extends Number> rows, double[] percentiles) {
        List boxedPercentiles = (List)Arrays.stream(percentiles).sorted().boxed().collect(ImmutableList.toImmutableList());
        List lowerBounds = (List)boxedPercentiles.stream().map(percentile -> this.getLowerBoundValue(error, rows, (double)percentile)).collect(ImmutableList.toImmutableList());
        List upperBounds = (List)boxedPercentiles.stream().map(percentile -> this.getUpperBoundValue(error, rows, (double)percentile)).collect(ImmutableList.toImmutableList());
        this.functionAssertions.assertFunction(String.format("zip_with(values_at_quantiles(CAST(X'%s' AS %s(%s)), ARRAY[%s]), ARRAY[%s], (value, lowerbound) -> value >= lowerbound)", binary.toString().replaceAll("\\s+", " "), method, type, ARRAY_JOINER.join((Iterable)boxedPercentiles), ARRAY_JOINER.join((Iterable)lowerBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
        this.functionAssertions.assertFunction(String.format("zip_with(values_at_quantiles(CAST(X'%s' AS %s(%s)), ARRAY[%s]), ARRAY[%s], (value, upperbound) -> value <= upperbound)", binary.toString().replaceAll("\\s+", " "), method, type, ARRAY_JOINER.join((Iterable)boxedPercentiles), ARRAY_JOINER.join((Iterable)upperBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
    }

    private Number getLowerBoundValue(double error, List<? extends Number> rows, double percentile) {
        int medianIndex = (int)((double)rows.size() * percentile);
        int marginOfError = (int)((double)rows.size() * error / 2.0);
        return rows.get(Integer.max(medianIndex - marginOfError, 0));
    }

    private Number getUpperBoundValue(double error, List<? extends Number> rows, double percentile) {
        int medianIndex = (int)((double)rows.size() * percentile);
        int marginOfError = (int)((double)rows.size() * error / 2.0);
        return rows.get(Integer.min(medianIndex + marginOfError, rows.size() - 1));
    }
}

