/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentHistogram;
import com.facebook.presto.operator.aggregation.state.LongApproximateMostFrequentStateSerializer;
import com.facebook.presto.operator.aggregation.state.StringApproximateMostFrequentStateSerializer;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestApproximateMostFrequentHistogram {
    @Test
    public void testLongHistogram() {
        ApproximateMostFrequentHistogram histogram = new ApproximateMostFrequentHistogram(3, 15, LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
        histogram.add((Object)1L);
        histogram.add((Object)1L);
        histogram.add((Object)2L);
        histogram.add((Object)3L);
        histogram.add((Object)4L);
        Map buckets = histogram.getBuckets();
        Assert.assertEquals((int)buckets.size(), (int)3);
        Assert.assertEquals((Map)buckets, (Map)ImmutableMap.of((Object)1L, (Object)2L, (Object)2L, (Object)1L, (Object)3L, (Object)1L));
    }

    @Test
    public void testLongRoundtrip() {
        ApproximateMostFrequentHistogram original = new ApproximateMostFrequentHistogram(3, 15, LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
        original.add((Object)1L);
        original.add((Object)1L);
        original.add((Object)2L);
        original.add((Object)3L);
        original.add((Object)4L);
        Slice serialized = original.serialize();
        ApproximateMostFrequentHistogram deserialized = new ApproximateMostFrequentHistogram(serialized, LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
        Assert.assertEquals((Map)deserialized.getBuckets(), (Map)original.getBuckets());
    }

    @Test
    public void testMerge() {
        ApproximateMostFrequentHistogram histogram1 = new ApproximateMostFrequentHistogram(3, 15, LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
        histogram1.add((Object)1L);
        histogram1.add((Object)1L);
        histogram1.add((Object)2L);
        ApproximateMostFrequentHistogram histogram2 = new ApproximateMostFrequentHistogram(3, 15, LongApproximateMostFrequentStateSerializer::serializeBucket, LongApproximateMostFrequentStateSerializer::deserializeBucket);
        histogram2.add((Object)3L);
        histogram2.add((Object)4L);
        histogram1.merge(histogram2);
        Map buckets = histogram1.getBuckets();
        Assert.assertEquals((int)buckets.size(), (int)3);
        Assert.assertEquals((Map)buckets, (Map)ImmutableMap.of((Object)1L, (Object)2L, (Object)2L, (Object)1L, (Object)3L, (Object)1L));
    }

    @Test
    public void testStringHistogram() {
        ApproximateMostFrequentHistogram histogram = new ApproximateMostFrequentHistogram(3, 15, StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
        histogram.add((Object)Slices.utf8Slice((String)"A"));
        histogram.add((Object)Slices.utf8Slice((String)"A"));
        histogram.add((Object)Slices.utf8Slice((String)"B"));
        histogram.add((Object)Slices.utf8Slice((String)"C"));
        histogram.add((Object)Slices.utf8Slice((String)"D"));
        Map buckets = histogram.getBuckets();
        Assert.assertEquals((int)buckets.size(), (int)3);
        Assert.assertEquals((Map)buckets, (Map)ImmutableMap.of((Object)Slices.utf8Slice((String)"A"), (Object)2L, (Object)Slices.utf8Slice((String)"B"), (Object)1L, (Object)Slices.utf8Slice((String)"C"), (Object)1L));
    }

    @Test
    public void testStringRoundtrip() {
        ApproximateMostFrequentHistogram original = new ApproximateMostFrequentHistogram(3, 15, StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
        original.add((Object)Slices.utf8Slice((String)"A"));
        original.add((Object)Slices.utf8Slice((String)"A"));
        original.add((Object)Slices.utf8Slice((String)"B"));
        original.add((Object)Slices.utf8Slice((String)"C"));
        original.add((Object)Slices.utf8Slice((String)"D"));
        Slice serialized = original.serialize();
        ApproximateMostFrequentHistogram deserialized = new ApproximateMostFrequentHistogram(serialized, StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
        Assert.assertEquals((Map)deserialized.getBuckets(), (Map)original.getBuckets());
    }
}

