/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import org.testng.annotations.Test;

public class TestIllegalMethodAggregation {
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, invalid method: no_such_method")
    public void testIllegalMethod() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        InternalAggregationFunction function = functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("differential_entropy", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE})));
        AggregationTestUtils.aggregation(function, BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(0.1), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createStringsBlock("no_such_method"), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(1.0));
    }

    @Test
    public void testNullMethod() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        InternalAggregationFunction function = functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("differential_entropy", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE})));
        BlockAssertions.createStringsBlock(new String[]{null});
        AggregationTestUtils.aggregation(function, BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(0.1), BlockAssertions.createDoublesBlock(-0.2), BlockAssertions.createStringsBlock(new String[]{null}), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(1.0));
    }
}

