/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.fixedhistogram;

import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleBreakdownHistogram;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixedDoubleBreakdownHistogram {
    @Test
    public void testGetters() {
        FixedDoubleBreakdownHistogram histogram = new FixedDoubleBreakdownHistogram(200, 3.0, 4.0);
        Assert.assertEquals((int)histogram.getBucketCount(), (int)200);
        Assert.assertEquals((Object)histogram.getMin(), (Object)3.0);
        Assert.assertEquals((Object)histogram.getMax(), (Object)4.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="bucketCount must be at least 2: -200")
    public void testIllegalBucketCount() {
        new FixedDoubleBreakdownHistogram(-200, 3.0, 4.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="min must be smaller than max: 3.0 3.0")
    public void testIllegalMinMax() {
        new FixedDoubleBreakdownHistogram(200, 3.0, 3.0);
    }

    @Test
    public void testBasicOps() {
        FixedDoubleBreakdownHistogram histogram = new FixedDoubleBreakdownHistogram(200, 3.0, 4.0);
        histogram.add(3.1, 100.0);
        histogram.add(3.8, 200.0);
        histogram.add(3.1, 100.0);
        Assert.assertEquals((Object)Streams.stream((Iterator)histogram.iterator()).mapToDouble(FixedDoubleBreakdownHistogram.Bucket::getWeight).sum(), (Object)300.0);
    }

    @Test
    public void testEqualValuesDifferentWeights() {
        FixedDoubleBreakdownHistogram histogram = new FixedDoubleBreakdownHistogram(200, 3.0, 4.0);
        histogram.add(3.5, 0.2, 1L);
        histogram.add(3.5, 0.4, 1L);
        histogram.add(3.5, 0.3, 2L);
        Streams.stream((Iterator)histogram.iterator()).forEach(bucketWeight -> {
            Assert.assertTrue((bucketWeight.getLeft() <= 3.5 ? 1 : 0) != 0);
            Assert.assertTrue((bucketWeight.getRight() >= 3.5 ? 1 : 0) != 0);
            Assert.assertTrue((bucketWeight.getLeft() < bucketWeight.getRight() ? 1 : 0) != 0);
        });
        Assert.assertEquals((long)Streams.stream((Iterator)histogram.iterator()).count(), (long)3L);
        Assert.assertEquals((Object)Streams.stream((Iterator)histogram.iterator()).mapToDouble(FixedDoubleBreakdownHistogram.Bucket::getWeight).sum(), (Object)0.9);
        Assert.assertEquals((long)Streams.stream((Iterator)histogram.iterator()).mapToLong(FixedDoubleBreakdownHistogram.Bucket::getCount).sum(), (long)4L);
    }

    @Test
    public void testMassive() {
        FixedDoubleBreakdownHistogram histogram = new FixedDoubleBreakdownHistogram(100, 0.0, 1.0);
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (int i = 0; i < 1000000; ++i) {
            double value = Math.random();
            double weight = (double)((int)(10.0 * Math.random())) / 10.0;
            values.add(value);
            weights.add(weight);
            histogram.add(value, weight, 1L);
        }
        Streams.stream((Iterator)histogram.iterator()).forEach(bucketWeight -> {
            long count = 0L;
            for (int i = 0; i < values.size(); ++i) {
                if (!(bucketWeight.getLeft() < (Double)values.get(i)) || !((Double)values.get(i) <= bucketWeight.getRight()) || bucketWeight.getWeight() != ((Double)weights.get(i)).doubleValue()) continue;
                ++count;
            }
            Assert.assertEquals((long)bucketWeight.getCount(), (long)count);
        });
    }

    @Test
    public void testMassiveMerge() {
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        FixedDoubleBreakdownHistogram left = new FixedDoubleBreakdownHistogram(100, 0.0, 1.0);
        for (int i = 0; i < 100; ++i) {
            double value = Math.random();
            double weight = Math.random();
            values.add(value);
            weights.add(weight);
            left.add(value, weight, 1L);
        }
        FixedDoubleBreakdownHistogram right = new FixedDoubleBreakdownHistogram(100, 0.0, 1.0);
        ArrayList<Double> rightValues = new ArrayList<Double>();
        ArrayList<Double> rightWeights = new ArrayList<Double>();
        for (int i = 0; i < 100; ++i) {
            double value = Math.random();
            double weight = Math.random();
            values.add(value);
            weights.add(weight);
            rightValues.add(value);
            rightWeights.add(weight);
            right.add(value, weight, 1L);
        }
        left.mergeWith(right.clone());
        Streams.stream((Iterator)left.iterator()).forEach(b -> {
            long count = IntStream.range(0, values.size()).filter(i -> b.getLeft() < (Double)values.get(i) && (Double)values.get(i) <= b.getRight() && b.getWeight() == ((Double)weights.get(i)).doubleValue()).count();
            Assert.assertEquals((long)b.getCount(), (long)count);
        });
        Streams.stream((Iterator)right.iterator()).forEach(b -> {
            long count = IntStream.range(0, rightValues.size()).filter(i -> b.getLeft() < (Double)rightValues.get(i) && (Double)rightValues.get(i) <= b.getRight() && b.getWeight() == ((Double)rightWeights.get(i)).doubleValue()).count();
            Assert.assertEquals((long)b.getCount(), (long)count);
        });
    }
}

