/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.groupByAggregations;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import org.testng.Assert;

public class GroupByAggregationTestUtils {
    private GroupByAggregationTestUtils() {
        throw new UnsupportedOperationException("util class only");
    }

    public static Page[] createPages(Block[] blocks) {
        int positions = blocks[0].getPositionCount();
        for (int i = 1; i < blocks.length; ++i) {
            Assert.assertEquals((int)positions, (int)blocks[i].getPositionCount(), (String)"input blocks provided are not equal in position count");
        }
        if (positions == 0) {
            return new Page[0];
        }
        if (positions == 1) {
            return new Page[]{new Page(positions, blocks)};
        }
        int split = positions / 2;
        Block[] blockArray1 = new Block[blocks.length];
        Block[] blockArray2 = new Block[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            blockArray1[i] = blocks[i].getRegion(0, split);
            blockArray2[i] = blocks[i].getRegion(split, positions - split);
        }
        return new Page[]{new Page(blockArray1), new Page(blockArray2)};
    }

    public static int[] createArgs(InternalAggregationFunction function) {
        int[] args = new int[function.getParameterTypes().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = i;
        }
        return args;
    }
}

