/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.annotations.Test;

public class TestTupleFilterProcessor {
    @Test
    public void testFilter() {
        Page tuplePage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(1L, "a", 0.1).build());
        ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        Page inputPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("b", 1L, true, 0.1, 2.0).row("a", 1L, false, 0.1, 2.0).row("a", 0L, false, 0.2, 0.2).build());
        DynamicTupleFilterFactory filterFactory = new DynamicTupleFilterFactory(42, new PlanNodeId("42"), new int[]{0, 1, 2}, new int[]{1, 0, 3}, (List)outputTypes, TestingConnectorSession.SESSION.getSqlFunctionProperties(), new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0));
        PageProcessor tupleFilterProcessor = (PageProcessor)filterFactory.createPageProcessor(tuplePage, OptionalInt.of(8192)).get();
        Page actualPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)tupleFilterProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), inputPage))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Page expectedPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("a", 1L, false, 0.1, 2.0).build());
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, actualPage, expectedPage);
    }
}

