/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.BucketPartitionFunction;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.repartition.OptimizedPartitionedOutputOperator;
import com.facebook.presto.operator.repartition.PartitionedOutputOperator;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPartitionedOutputOperator {
    @Benchmark
    public void addPage(BenchmarkData data) {
        PartitionedOutputOperator operator = data.createPartitionedOutputOperator();
        for (int i = 0; i < data.pageCount; ++i) {
            operator.addInput(data.dataPage);
        }
        operator.finish();
    }

    @Benchmark
    public void optimizedAddPage(BenchmarkData data) {
        OptimizedPartitionedOutputOperator operator = data.createOptimizedPartitionedOutputOperator();
        for (int i = 0; i < data.pageCount; ++i) {
            operator.addInput(data.dataPage);
        }
        operator.finish();
    }

    @Test
    public void verifyAddPage() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkPartitionedOutputOperator().addPage(data);
    }

    @Test
    public void verifyOptimizedAddPage() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkPartitionedOutputOperator().optimizedAddPage(data);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).jvmArgs(new String[]{"-Xmx10g"}).include(".*" + BenchmarkPartitionedOutputOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int PARTITION_COUNT = 256;
        private static final int POSITION_COUNT = 8192;
        private static final DataSize MAX_MEMORY = new DataSize(4.0, DataSize.Unit.GIGABYTE);
        private static final DataSize MAX_PARTITION_BUFFER_SIZE = new DataSize(256.0, DataSize.Unit.MEGABYTE);
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-EXECUTOR-%s"));
        private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"test-%s"));
        @Param(value={"true", "false"})
        private boolean enableCompression;
        @Param(value={"1", "2"})
        private int channelCount = 1;
        @Param(value={"BIGINT", "DICTIONARY(BIGINT)", "RLE(BIGINT)", "LONG_DECIMAL", "INTEGER", "SMALLINT", "BOOLEAN", "VARCHAR", "ARRAY(BIGINT)", "ARRAY(VARCHAR)", "ARRAY(ARRAY(BIGINT))", "MAP(BIGINT,BIGINT)", "MAP(BIGINT,MAP(BIGINT,BIGINT))", "ROW(BIGINT,BIGINT)", "ROW(ARRAY(BIGINT),ARRAY(BIGINT))"})
        private String type = "BIGINT";
        @Param(value={"true", "false"})
        private boolean hasNull;
        private List<Type> types;
        private int pageCount;
        private Page dataPage;

        @Setup
        public void setup() {
            this.createPages(this.type);
        }

        private void createPages(String inputType) {
            float primitiveNullRate = 0.0f;
            float nestedNullRate = 0.0f;
            if (this.hasNull) {
                primitiveNullRate = 0.2f;
                nestedNullRate = 0.2f;
            }
            switch (inputType) {
                case "BIGINT": {
                    this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "DICTIONARY(BIGINT)": {
                    this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
                    this.dataPage = PageAssertions.createDictionaryPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 3000;
                    break;
                }
                case "RLE(BIGINT)": {
                    this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
                    this.dataPage = PageAssertions.createRlePageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 3000;
                    break;
                }
                case "LONG_DECIMAL": {
                    this.types = Collections.nCopies(this.channelCount, DecimalType.createDecimalType((int)19));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "INTEGER": {
                    this.types = Collections.nCopies(this.channelCount, IntegerType.INTEGER);
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "SMALLINT": {
                    this.types = Collections.nCopies(this.channelCount, SmallintType.SMALLINT);
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "BOOLEAN": {
                    this.types = Collections.nCopies(this.channelCount, BooleanType.BOOLEAN);
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "VARCHAR": {
                    this.types = Collections.nCopies(this.channelCount, VarcharType.VARCHAR);
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 5000;
                    break;
                }
                case "ARRAY(BIGINT)": {
                    this.types = Collections.nCopies(this.channelCount, new ArrayType((Type)BigintType.BIGINT));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "ARRAY(VARCHAR)": {
                    this.types = Collections.nCopies(this.channelCount, new ArrayType((Type)VarcharType.VARCHAR));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "ARRAY(ARRAY(BIGINT))": {
                    this.types = Collections.nCopies(this.channelCount, new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "MAP(BIGINT,BIGINT)": {
                    this.types = Collections.nCopies(this.channelCount, BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "MAP(BIGINT,MAP(BIGINT,BIGINT))": {
                    this.types = Collections.nCopies(this.channelCount, BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "ROW(BIGINT,BIGINT)": {
                    this.types = Collections.nCopies(this.channelCount, RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                case "ROW(ARRAY(BIGINT),ARRAY(BIGINT))": {
                    this.types = Collections.nCopies(this.channelCount, RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT))));
                    this.dataPage = PageAssertions.createPageWithRandomData(this.types, 8192, primitiveNullRate, nestedNullRate);
                    this.pageCount = 1000;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported dataType");
                }
            }
            this.types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(this.types, true, false);
        }

        private PartitionedOutputBuffer createPartitionedOutputBuffer() {
            OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
            for (int partition = 0; partition < 256; ++partition) {
                buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
            }
            TestingPartitionedOutputBuffer buffer = this.createPartitionedBuffer(buffers.withNoMoreBufferIds(), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE));
            buffer.registerLifespanCompletionCallback(ignore -> {});
            return buffer;
        }

        private OptimizedPartitionedOutputOperator createOptimizedPartitionedOutputOperator() {
            BucketPartitionFunction partitionFunction = new BucketPartitionFunction(SystemPartitioningHandle.SystemPartitionFunction.HASH.createBucketFunction((List)ImmutableList.of((Object)BigintType.BIGINT), true, 256), IntStream.range(0, 256).toArray());
            OutputPartitioning outputPartitioning = this.createOutputPartitioning((PartitionFunction)partitionFunction);
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager(new BlockEncoding[0]), this.enableCompression);
            PartitionedOutputBuffer buffer = this.createPartitionedOutputBuffer();
            OptimizedPartitionedOutputOperator.OptimizedPartitionedOutputFactory operatorFactory = new OptimizedPartitionedOutputOperator.OptimizedPartitionedOutputFactory((OutputBuffer)buffer, MAX_PARTITION_BUFFER_SIZE);
            return (OptimizedPartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), this.types, Function.identity(), Optional.of(outputPartitioning), serdeFactory).createOperator(this.createDriverContext());
        }

        private PartitionedOutputOperator createPartitionedOutputOperator() {
            LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new PrecomputedHashGenerator(0), 256);
            OutputPartitioning outputPartitioning = this.createOutputPartitioning((PartitionFunction)partitionFunction);
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager(new BlockEncoding[0]), this.enableCompression);
            PartitionedOutputBuffer buffer = this.createPartitionedOutputBuffer();
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((OutputBuffer)buffer, MAX_PARTITION_BUFFER_SIZE);
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), this.types, Function.identity(), Optional.of(outputPartitioning), serdeFactory).createOperator(this.createDriverContext());
        }

        private OutputPartitioning createOutputPartitioning(PartitionFunction partitionFunction) {
            return new OutputPartitioning(partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty(), Optional.empty()), false, OptionalInt.empty());
        }

        private DriverContext createDriverContext() {
            Session testSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
            return TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)testSession).setMemoryPoolSize(MAX_MEMORY).setQueryMaxTotalMemory(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
        }

        private TestingPartitionedOutputBuffer createPartitionedBuffer(OutputBuffers buffers, DataSize dataSize) {
            return new TestingPartitionedOutputBuffer("task-instance-id", (StateMachine<BufferState>)new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), SCHEDULER);
        }

        private static class TestingPartitionedOutputBuffer
        extends PartitionedOutputBuffer {
            public TestingPartitionedOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, OutputBuffers outputBuffers, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier, Executor notificationExecutor) {
                super(taskInstanceId, state, outputBuffers, maxBufferSize, systemMemoryContextSupplier, notificationExecutor);
            }

            public void enqueue(Lifespan lifespan, int partitionNumber, List<SerializedPage> pages) {
            }
        }
    }
}

