/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapConcat {
    private static final int POSITIONS = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public List<Optional<Page>> mapConcat(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapConcat().mapConcat(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.INDI).include(".*" + BenchmarkMapConcat.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String name = "map_concat";
        @Param(value={"left_empty", "right_empty", "both_empty", "non_empty"})
        private String mapConfig = "left_empty";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            ImmutableList rightKeys;
            ImmutableList leftKeys;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            switch (this.mapConfig) {
                case "left_empty": {
                    leftKeys = ImmutableList.of();
                    rightKeys = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
                    break;
                }
                case "right_empty": {
                    leftKeys = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
                    rightKeys = ImmutableList.of();
                    break;
                }
                case "both_empty": {
                    leftKeys = ImmutableList.of();
                    rightKeys = ImmutableList.of();
                    break;
                }
                case "non_empty": {
                    leftKeys = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
                    rightKeys = ImmutableList.of((Object)"d", (Object)"b", (Object)"c");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
            Block leftKeyBlock = BenchmarkData.createKeyBlock(10000, (List<String>)leftKeys);
            Block leftValueBlock = BenchmarkData.createValueBlock(10000, leftKeys.size());
            Block leftBlock = BenchmarkData.createMapBlock(mapType, 10000, leftKeyBlock, leftValueBlock);
            Block rightKeyBlock = BenchmarkData.createKeyBlock(10000, (List<String>)rightKeys);
            Block rightValueBlock = BenchmarkData.createValueBlock(10000, rightKeys.size());
            Block rightBlock = BenchmarkData.createMapBlock(mapType, 10000, rightKeyBlock, rightValueBlock);
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            FunctionHandle functionHandle = metadata.getFunctionAndTypeManager().lookupFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType, mapType}));
            projectionsBuilder.add((Object)new CallExpression(this.name, functionHandle, (Type)mapType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)Expressions.field((int)1, (Type)mapType))));
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{leftBlock, rightBlock});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }

        private static Block createMapBlock(MapType mapType, int positionCount, Block keyBlock, Block valueBlock) {
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(positionCount, Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createKeyBlock(int positionCount, List<String> keys) {
            Block keyDictionaryBlock = BenchmarkData.createSliceArrayBlock(keys);
            int[] keyIds = new int[positionCount * keys.size()];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = i % keys.size();
            }
            return new DictionaryBlock(keyDictionaryBlock, keyIds);
        }

        private static Block createValueBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                DoubleType.DOUBLE.writeDouble(valueBlockBuilder, ThreadLocalRandom.current().nextDouble());
            }
            return valueBlockBuilder.build();
        }

        private static Block createSliceArrayBlock(List<String> keys) {
            Slice[] sliceArray = new Slice[keys.size() + 1];
            for (int i = 0; i < keys.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)keys.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }
    }
}

