/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestArrayExceptFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("array_except(ARRAY[1, 5, 3], ARRAY[3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)5));
        this.assertFunction("array_except(ARRAY[CAST(1 as BIGINT), 5, 3], ARRAY[5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L, (Object)3L));
        this.assertFunction("array_except(ARRAY[CAST('x' as VARCHAR), 'y', 'z'], ARRAY['x'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"y", (Object)"z"));
        this.assertFunction("array_except(ARRAY[true, false, null], ARRAY[true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(false, null));
        this.assertFunction("array_except(ARRAY[1.1E0, 5.4E0, 3.9E0], ARRAY[5, 5.4E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.1, (Object)3.9));
    }

    @Test
    public void testEmpty() {
        this.assertFunction("array_except(ARRAY[], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_except(ARRAY[], ARRAY[1, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_except(ARRAY[CAST('abc' as VARCHAR)], ARRAY[])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"abc"));
    }

    @Test
    public void testNull() {
        this.assertFunction("array_except(ARRAY[NULL], NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_except(NULL, NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_except(NULL, ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_except(ARRAY[NULL], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_except(ARRAY[], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_except(ARRAY[NULL], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Collections.singletonList(null));
    }

    @Test
    public void testDuplicates() {
        this.assertFunction("array_except(ARRAY[1, 5, 3, 5, 1], ARRAY[3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)5));
        this.assertFunction("array_except(ARRAY[CAST(1 as BIGINT), 5, 5, 3, 3, 3, 1], ARRAY[3, 5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)1L));
        this.assertFunction("array_except(ARRAY[CAST('x' as VARCHAR), 'x', 'y', 'z'], ARRAY['x', 'y', 'x'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"z"));
        this.assertFunction("array_except(ARRAY[true, false, null, true, false, null], ARRAY[true, true, true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(false, null));
    }
}

