/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestArrayFilterFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("filter(ARRAY [5, 6], x -> x = 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5));
        this.assertFunction("filter(ARRAY [5 + RANDOM(1), 6 + RANDOM(1)], x -> x = 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5));
        this.assertFunction("filter(ARRAY [true, false, true, false], x -> nullif(x, false))", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true));
        this.assertFunction("filter(ARRAY [true, false, null, true, false, null], x -> not x)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false, (Object)false));
    }

    @Test
    public void testEmpty() {
        this.assertFunction("filter(ARRAY [], x -> true)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("filter(ARRAY [], x -> false)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("filter(ARRAY [], x -> CAST (null AS BOOLEAN))", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("filter(CAST (ARRAY [] AS ARRAY(INTEGER)), x -> true)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("filter(ARRAY [NULL], x -> x IS NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Collections.singletonList(null));
        this.assertFunction("filter(ARRAY [NULL], x -> x IS NOT NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("filter(ARRAY [CAST (NULL AS INTEGER)], x -> x IS NULL)", (Type)new ArrayType((Type)IntegerType.INTEGER), Collections.singletonList(null));
        this.assertFunction("filter(ARRAY [NULL, NULL, NULL], x -> x IS NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(null, null, null));
        this.assertFunction("filter(ARRAY [NULL, NULL, NULL], x -> x IS NOT NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("filter(ARRAY [25, 26, NULL], x -> x % 2 = 1 OR x IS NULL)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(25, null));
        this.assertFunction("filter(ARRAY [25.6E0, 37.3E0, NULL], x -> x < 30.0E0 OR x IS NULL)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(25.6, null));
        this.assertFunction("filter(ARRAY [true, false, NULL], x -> not x OR x IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(false, null));
        this.assertFunction("filter(ARRAY ['abc', 'def', NULL], x -> substr(x, 1, 1) = 'a' OR x IS NULL)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null));
        this.assertFunction("filter(ARRAY [ARRAY ['abc', null, '123'], NULL], x -> x[2] IS NULL OR x IS NULL)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), Arrays.asList(Arrays.asList("abc", null, "123"), null));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("filter(ARRAY [25, 26, 27], x -> x % 2 = 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)25, (Object)27));
        this.assertFunction("filter(ARRAY [25.6E0, 37.3E0, 28.6E0], x -> x < 30.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)25.6, (Object)28.6));
        this.assertFunction("filter(ARRAY [true, false, true], x -> not x)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false));
        this.assertFunction("filter(ARRAY ['abc', 'def', 'ayz'], x -> substr(x, 1, 1) = 'a')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc", (Object)"ayz"));
        this.assertFunction("filter(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> x[2] IS NULL)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of(Arrays.asList("abc", null, "123")));
    }
}

