/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.testing.TestingSession;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestArrayReduceFunction
extends AbstractTestFunctions {
    public TestArrayReduceFunction() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Kiritimati")).build());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("reduce(ARRAY [], CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testBasic() {
        this.assertFunction("reduce(ARRAY [5, 20, 50], CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)", (Type)BigintType.BIGINT, 75L);
        this.assertFunction("reduce(ARRAY [5 + RANDOM(1), 20, 50], CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)", (Type)BigintType.BIGINT, 75L);
        this.assertFunction("reduce(ARRAY [5, 6, 10, 20], 0.0E0, (s, x) -> s + x, s -> s)", (Type)DoubleType.DOUBLE, 41.0);
    }

    @Test
    public void testNulls() {
        this.assertFunction("reduce(ARRAY [NULL], CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)", (Type)BigintType.BIGINT, null);
        this.assertFunction("reduce(ARRAY [NULL, NULL, NULL], CAST (0 AS BIGINT), (s, x) -> coalesce(x, 1) + s, s -> s)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("reduce(ARRAY [5, NULL, 50], CAST (0 AS BIGINT), (s, x) -> s + x, s -> s)", (Type)BigintType.BIGINT, null);
        this.assertFunction("reduce(ARRAY [5, NULL, 50], CAST (0 AS BIGINT), (s, x) -> coalesce(x, 0) + s, s -> s)", (Type)BigintType.BIGINT, 55L);
        this.assertFunction("reduce(ARRAY [], CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)", (Type)BigintType.BIGINT, null);
        this.assertFunction("reduce(ARRAY [NULL], CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)", (Type)BigintType.BIGINT, null);
        this.assertFunction("reduce(ARRAY [NULL, NULL, NULL], CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)", (Type)BigintType.BIGINT, null);
        this.assertFunction("reduce(ARRAY [NULL, 6, 10, NULL, 8], CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)", (Type)BigintType.BIGINT, 10L);
        this.assertFunction("reduce(ARRAY [5, NULL, 6, 10, NULL, 8], CAST (NULL AS BIGINT), (s, x) -> IF(s IS NULL OR x > s, x, s), s -> s)", (Type)BigintType.BIGINT, 10L);
    }

    @Test
    public void testTwoValueState() {
        this.assertFunction("reduce(ARRAY [5, 20, 50], CAST(ROW(0, 0) AS ROW(sum BIGINT, count INTEGER)), (s, x) -> CAST(ROW(x + s.sum, s.count + 1) AS ROW(sum BIGINT, count INTEGER)), s -> s.sum / s.count)", (Type)BigintType.BIGINT, 25L);
        this.assertFunction("reduce(ARRAY [5, 6, 10, 20], CAST(ROW(0.0E0, 0) AS ROW(sum DOUBLE, count INTEGER)), (s, x) -> CAST(ROW(x + s.sum, s.count + 1) AS ROW(sum DOUBLE, count INTEGER)), s -> s.sum / s.count)", (Type)DoubleType.DOUBLE, 10.25);
    }

    @Test
    public void testInstanceFunction() {
        this.assertFunction("reduce(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[5, NULL, 7]], CAST(ARRAY[] AS ARRAY(INTEGER)), (s, x) -> concat(s, x), s -> s)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, 2, 3, 4, 5, null, 7));
    }

    @Test
    public void testCoercion() {
        this.assertFunction("reduce(ARRAY [123456789012345, NULL, 54321], 0, (s, x) -> s + coalesce(x, 0), s -> s)", (Type)BigintType.BIGINT, 123456789066666L);
        this.assertInvalidFunction("reduce(ARRAY [1, NULL, 2], 0, (s, x) -> CAST (s + x AS TINYINT), s -> s)", SemanticErrorCode.FUNCTION_NOT_FOUND);
    }
}

