/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Failures;
import org.testng.annotations.Test;

public class TestFailureFunction
extends AbstractTestFunctions {
    private static final String FAILURE_INFO = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure((Throwable)new RuntimeException("fail me")).toFailureInfo());

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="fail me")
    public void testFailure() {
        this.assertFunction("fail(json_parse('" + FAILURE_INFO + "'))", (Type)UnknownType.UNKNOWN, null);
    }

    @Test
    public void testQuery() {
        LocalQueryRunner runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
        Throwable throwable = null;
        try {
            try {
                runner.execute("select if(x, 78, 0/0) from (values rand() >= 0, rand() < 0) t(x)");
                throw new RuntimeException("Should throw PrestoException");
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.DIVISION_BY_ZERO.toErrorCode());
                org.testng.Assert.assertTrue((boolean)e.getMessage().contains("/ by zero"));
                if (runner != null) {
                    if (throwable != null) {
                        try {
                            runner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        runner.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (runner != null) {
                    if (throwable != null) {
                        try {
                            runner.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        runner.close();
                    }
                }
                throw throwable4;
            }
        }
    }
}

