/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.QuantileDigestParametricType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQuantileDigestFunctions
extends AbstractTestFunctions {
    private static final Type QDIGEST_BIGINT = QuantileDigestParametricType.QDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)BigintType.BIGINT)));

    @Test
    public void testNullQuantileDigestGetValueAtQuantile() {
        this.functionAssertions.assertFunction("value_at_quantile(CAST(NULL AS qdigest(bigint)), 0.3)", (Type)BigintType.BIGINT, null);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Quantile should be within bounds \\[0, 1\\], was: \\d+\\.\\d+")
    public void testGetValueAtQuantileOverOne() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS qdigest(bigint)), 1.5)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)BigintType.BIGINT, null);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Quantile should be within bounds \\[0, 1\\], was: -\\d+\\.\\d+")
    public void testGetValueAtQuantileBelowZero() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS qdigest(bigint)), -0.2)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testValueAtQuantileBigint() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS qdigest(bigint)), 0.5)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)BigintType.BIGINT, 5L);
    }

    @Test
    public void testQuantileAtValueBigint() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(bigint)), 20)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(bigint)), 6)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, 0.6);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(bigint)), -1)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testQuantileAtValueDouble() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9).stream().mapToLong(FloatingPointBitsConverterUtil::doubleToSortableLong).forEach(arg_0 -> ((QuantileDigest)qdigest).add(arg_0));
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(double)), 5.6)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, 0.6);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(double)), -1.23)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(double)), 12.3)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(double)), nan())", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testQuantileAtValueBigintWithEmptyDigest() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS qdigest(bigint)), 5)", TestQuantileDigestFunctions.toHexString(qdigest)), (Type)DoubleType.DOUBLE, null);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Scale factor should be positive\\.")
    public void testScaleNegative() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.functionAssertions.selectSingleValue(String.format("scale_qdigest(CAST(X'%s' AS qdigest(bigint)), -1)", TestQuantileDigestFunctions.toHexString(qdigest)), QDIGEST_BIGINT, SqlVarbinary.class);
    }

    @Test
    public void testScale() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        Assert.assertEquals((Collection)qdigest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(1.0, 0.0), new QuantileDigest.Bucket(1.0, 1.0), new QuantileDigest.Bucket(1.0, 2.0), new QuantileDigest.Bucket(1.0, 3.0), new QuantileDigest.Bucket(1.0, 4.0), new QuantileDigest.Bucket(1.0, 5.0), new QuantileDigest.Bucket(1.0, 6.0), new QuantileDigest.Bucket(1.0, 7.0), new QuantileDigest.Bucket(1.0, 8.0), new QuantileDigest.Bucket(1.0, 9.0)));
        SqlVarbinary sqlVarbinary = this.functionAssertions.selectSingleValue(String.format("scale_qdigest(CAST(X'%s' AS qdigest(bigint)), 2)", TestQuantileDigestFunctions.toHexString(qdigest)), QDIGEST_BIGINT, SqlVarbinary.class);
        QuantileDigest scaledQdigest = new QuantileDigest(Slices.wrappedBuffer((byte[])sqlVarbinary.getBytes()));
        Assert.assertEquals((Collection)scaledQdigest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(2.0, 0.0), new QuantileDigest.Bucket(2.0, 1.0), new QuantileDigest.Bucket(2.0, 2.0), new QuantileDigest.Bucket(2.0, 3.0), new QuantileDigest.Bucket(2.0, 4.0), new QuantileDigest.Bucket(2.0, 5.0), new QuantileDigest.Bucket(2.0, 6.0), new QuantileDigest.Bucket(2.0, 7.0), new QuantileDigest.Bucket(2.0, 8.0), new QuantileDigest.Bucket(2.0, 9.0)));
        sqlVarbinary = this.functionAssertions.selectSingleValue(String.format("scale_qdigest(CAST(X'%s' AS qdigest(bigint)), 0.5)", TestQuantileDigestFunctions.toHexString(qdigest)), QDIGEST_BIGINT, SqlVarbinary.class);
        scaledQdigest = new QuantileDigest(Slices.wrappedBuffer((byte[])sqlVarbinary.getBytes()));
        Assert.assertEquals((Collection)scaledQdigest.getHistogram(Arrays.asList(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)), Arrays.asList(new QuantileDigest.Bucket(0.0, Double.NaN), new QuantileDigest.Bucket(0.5, 0.0), new QuantileDigest.Bucket(0.5, 1.0), new QuantileDigest.Bucket(0.5, 2.0), new QuantileDigest.Bucket(0.5, 3.0), new QuantileDigest.Bucket(0.5, 4.0), new QuantileDigest.Bucket(0.5, 5.0), new QuantileDigest.Bucket(0.5, 6.0), new QuantileDigest.Bucket(0.5, 7.0), new QuantileDigest.Bucket(0.5, 8.0), new QuantileDigest.Bucket(0.5, 9.0)));
    }

    private static void addAll(QuantileDigest digest, long ... values) {
        Objects.requireNonNull(values, "values is null");
        for (long value : values) {
            digest.add(value);
        }
    }

    private static String toHexString(QuantileDigest qdigest) {
        return new SqlVarbinary(qdigest.serialize().getBytes()).toString().replaceAll("\\s+", " ");
    }
}

