/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.UnknownType;
import java.util.Arrays;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTryFunction
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long throwError() {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "internal error, should not be suppressed by $internal$try");
    }

    @Test
    public void testBasic() {
        this.assertFunction("\"$internal$try\"(() -> 42)", (Type)IntegerType.INTEGER, 42);
        this.assertFunction("\"$internal$try\"(() -> DOUBLE '4.5')", (Type)DoubleType.DOUBLE, 4.5);
        this.assertFunction("\"$internal$try\"(() -> DECIMAL '4.5')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"4.5"));
        this.assertFunction("\"$internal$try\"(() -> TRUE)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("\"$internal$try\"(() -> 'hello')", (Type)VarcharType.createVarcharType((int)5), "hello");
        this.assertFunction("\"$internal$try\"(() -> JSON '[true, false, 12, 12.7, \"12\", null]')", (Type)JsonType.JSON, "[true,false,12,12.7,\"12\",null]");
        this.assertFunction("\"$internal$try\"(() -> ARRAY [1, 2])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, 2));
        this.assertFunction("\"$internal$try\"(() -> NULL)", (Type)UnknownType.UNKNOWN, null);
    }

    @Test
    public void testExceptions() {
        this.assertFunction("\"$internal$try\"(() -> 1/0)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("\"$internal$try\"(() -> JSON_PARSE('INVALID'))", (Type)JsonType.JSON, null);
        this.assertFunction("\"$internal$try\"(() -> CAST(NULL AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("\"$internal$try\"(() -> ABS(-9223372036854775807 - 1))", (Type)BigintType.BIGINT, null);
        this.assertInvalidFunction("\"$internal$try\"(() -> throw_error())", (ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR);
    }
}

