/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.window.AbstractTestWindowFunction;
import com.facebook.presto.testing.MaterializedResult;
import org.testng.annotations.Test;

public class TestLagFunction
extends AbstractTestWindowFunction {
    @Test
    public void testLagFunction() {
        this.assertWindowQuery("lag(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{6, "F", "1994-07-30"}).row(new Object[]{33, "F", "1992-02-21"}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", "1996-01-02"}).row(new Object[]{4, "O", "1996-12-01"}).row(new Object[]{7, "O", "1995-10-11"}).row(new Object[]{32, "O", "1996-01-10"}).row(new Object[]{34, "O", "1995-07-16"}).build());
        this.assertWindowQueryWithNulls("lag(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", "1993-10-14"}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", "1992-02-21"}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", "1998-07-21"}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, "1996-01-10"}).row(new Object[]{null, null, null}).build());
        this.assertWindowQuery("lag(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", 3}).row(new Object[]{6, "F", 5}).row(new Object[]{33, "F", 6}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", 1}).row(new Object[]{4, "O", 2}).row(new Object[]{7, "O", 4}).row(new Object[]{32, "O", 7}).row(new Object[]{34, "O", 32}).build());
        this.assertWindowQueryWithNulls("lag(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 5L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, 1L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, null}).build());
        this.assertWindowQuery("lag(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1977-01-01"}).row(new Object[]{5, "F", "1977-01-01"}).row(new Object[]{6, "F", "1993-10-14"}).row(new Object[]{33, "F", "1994-07-30"}).row(new Object[]{1, "O", "1977-01-01"}).row(new Object[]{2, "O", "1977-01-01"}).row(new Object[]{4, "O", "1996-01-02"}).row(new Object[]{7, "O", "1996-12-01"}).row(new Object[]{32, "O", "1995-10-11"}).row(new Object[]{34, "O", "1996-01-10"}).build());
        this.assertWindowQueryWithNulls("lag(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", "1977-01-01"}).row(new Object[]{5L, "F", "1977-01-01"}).row(new Object[]{6L, "F", "1993-10-14"}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", "1977-01-01"}).row(new Object[]{null, "O", "1977-01-01"}).row(new Object[]{1L, null, "1977-01-01"}).row(new Object[]{7L, null, "1977-01-01"}).row(new Object[]{null, null, null}).row(new Object[]{null, null, "1996-01-10"}).build());
        this.assertWindowQuery("lag(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", -1}).row(new Object[]{5, "F", -1}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 5}).row(new Object[]{1, "O", -1}).row(new Object[]{2, "O", -1}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 2}).row(new Object[]{32, "O", 4}).row(new Object[]{34, "O", 7}).build());
        this.assertWindowQueryWithNulls("lag(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", -1L}).row(new Object[]{5L, "F", -1L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 5L}).row(new Object[]{34L, "O", -1L}).row(new Object[]{null, "O", -1L}).row(new Object[]{1L, null, -1L}).row(new Object[]{7L, null, -1L}).row(new Object[]{null, null, 1L}).row(new Object[]{null, null, 7L}).build());
        this.assertWindowQuery("lag(orderkey, BIGINT '8' * 1000 * 1000 * 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("lag(orderkey, null, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("lag(orderkey, 0) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 5}).row(new Object[]{6, "F", 6}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 4}).row(new Object[]{7, "O", 7}).row(new Object[]{32, "O", 32}).row(new Object[]{34, "O", 34}).build());
        this.assertWindowQuery("date_format(lag(cast(orderdate as TIMESTAMP), 0) OVER (PARTITION BY orderstatus ORDER BY orderkey), '%Y-%m-%d')", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1994-07-30"}).row(new Object[]{6, "F", "1992-02-21"}).row(new Object[]{33, "F", "1993-10-27"}).row(new Object[]{1, "O", "1996-01-02"}).row(new Object[]{2, "O", "1996-12-01"}).row(new Object[]{4, "O", "1995-10-11"}).row(new Object[]{7, "O", "1996-01-10"}).row(new Object[]{32, "O", "1995-07-16"}).row(new Object[]{34, "O", "1998-07-21"}).build());
    }

    @Test
    public void testLagFunctionWithNullTreatment() {
        this.assertWindowQueryWithNulls("lag(orderkey, 1, -1) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", -1L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 5L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", -1L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, -1L}).row(new Object[]{7L, null, 1L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, null}).build());
        this.assertWindowQueryWithNulls("lag(orderstatus, 1, null) RESPECT NULLS OVER (ORDER BY orderkey, orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{1L, null, null}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", "F"}).row(new Object[]{6L, "F", "F"}).row(new Object[]{7L, null, "F"}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "F", "O"}).row(new Object[]{null, "O", "F"}).row(new Object[]{null, null, "O"}).row(new Object[]{null, null, null}).build());
        this.assertWindowQueryWithNulls("lag(orderstatus, 0) RESPECT NULLS OVER (ORDER BY orderkey, orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{1L, null, null}).row(new Object[]{3L, "F", "F"}).row(new Object[]{5L, "F", "F"}).row(new Object[]{6L, "F", "F"}).row(new Object[]{7L, null, null}).row(new Object[]{34L, "O", "O"}).row(new Object[]{null, "F", "F"}).row(new Object[]{null, "O", "O"}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQueryWithNulls("lag(orderkey, 1, -1) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", -1L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 5L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", -1L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, -1L}).row(new Object[]{7L, null, 1L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, 7L}).build());
        this.assertWindowQueryWithNulls("lag(orderstatus, 1, null) IGNORE NULLS OVER (ORDER BY orderkey, orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{1L, null, null}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", "F"}).row(new Object[]{6L, "F", "F"}).row(new Object[]{7L, null, "F"}).row(new Object[]{34L, "O", "F"}).row(new Object[]{null, "F", "O"}).row(new Object[]{null, "O", "F"}).row(new Object[]{null, null, "O"}).row(new Object[]{null, null, "O"}).build());
        this.assertWindowQueryWithNulls("lag(orderstatus, 0) IGNORE NULLS OVER (ORDER BY orderkey, orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{1L, null, null}).row(new Object[]{3L, "F", "F"}).row(new Object[]{5L, "F", "F"}).row(new Object[]{6L, "F", "F"}).row(new Object[]{7L, null, null}).row(new Object[]{34L, "O", "O"}).row(new Object[]{null, "F", "F"}).row(new Object[]{null, "O", "O"}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQueryWithNulls("lag(orderkey, 1, -1) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey), lag(orderkey, 1, -1) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", -1L, -1L}).row(new Object[]{5L, "F", 3L, 3L}).row(new Object[]{6L, "F", 5L, 5L}).row(new Object[]{null, "F", 6L, 6L}).row(new Object[]{34L, "O", -1L, -1L}).row(new Object[]{null, "O", 34L, 34L}).row(new Object[]{1L, null, -1L, -1L}).row(new Object[]{7L, null, 1L, 1L}).row(new Object[]{null, null, 7L, 7L}).row(new Object[]{null, null, null, 7L}).build());
    }
}

