/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.MockHttpServletRequest;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpRequestSessionContext {
    @Test
    public void testSessionContext() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").put((Object)"X-Presto-Role", (Object)"foo_connector=ALL").put((Object)"X-Presto-Role", (Object)"bar_connector=NONE").put((Object)"X-Presto-Role", (Object)"foobar_connector=ROLE{role}").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.foo=bar").put((Object)"X-Presto-Extra-Credential", (Object)"test.token.abc=xyz").build(), "testRemote");
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request);
        Assert.assertEquals((String)context.getSource(), (String)"testSource");
        Assert.assertEquals((String)context.getCatalog(), (String)"testCatalog");
        Assert.assertEquals((String)context.getSchema(), (String)"testSchema");
        Assert.assertEquals((Object)context.getIdentity(), (Object)new Identity("testUser", Optional.empty()));
        Assert.assertEquals((String)context.getClientInfo(), (String)"client-info");
        Assert.assertEquals((String)context.getLanguage(), (String)"zh-TW");
        Assert.assertEquals((String)context.getTimeZoneId(), (String)"Asia/Taipei");
        Assert.assertEquals((Map)context.getSystemProperties(), (Map)ImmutableMap.of((Object)"query_max_memory", (Object)"1GB", (Object)"join_distribution_type", (Object)"partitioned", (Object)"hash_partition_count", (Object)"43"));
        Assert.assertEquals((Map)context.getPreparedStatements(), (Map)ImmutableMap.of((Object)"query1", (Object)"select * from foo", (Object)"query2", (Object)"select * from bar"));
        Assert.assertEquals((Map)context.getIdentity().getRoles(), (Map)ImmutableMap.of((Object)"foo_connector", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty()), (Object)"bar_connector", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty()), (Object)"foobar_connector", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))));
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.of((Object)"test.token.foo", (Object)"bar", (Object)"test.token.abc", (Object)"xyz"));
    }

    @Test(expectedExceptions={WebApplicationException.class})
    public void testPreparedStatementsHeaderDoesNotParse() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"null").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=abcdefg").build(), "testRemote");
        new HttpRequestSessionContext((HttpServletRequest)request);
    }

    @Test
    public void testExtraCredentials() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").put((Object)"X-Presto-Role", (Object)"foo_connector=ALL").put((Object)"X-Presto-Role", (Object)"bar_connector=NONE").put((Object)"X-Presto-Role", (Object)"foobar_connector=ROLE{role}").put((Object)"X-Presto-Extra-Credential", (Object)("test.token.key1=" + TestHttpRequestSessionContext.urlEncode("bar=ab===,d"))).put((Object)"X-Presto-Extra-Credential", (Object)"test.token.key2=bar=ab===").put((Object)"X-Presto-Extra-Credential", (Object)("test.json=" + TestHttpRequestSessionContext.urlEncode("{\"a\" : \"b\", \"c\" : \"d=\"}") + ", test.token.key3 = abc=cd")).put((Object)"X-Presto-Extra-Credential", (Object)"test.token.abc=xyz").build(), "testRemote");
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request);
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.builder().put((Object)"test.token.key1", (Object)"bar=ab===,d").put((Object)"test.token.key2", (Object)"bar=ab===").put((Object)"test.token.key3", (Object)"abc=cd").put((Object)"test.json", (Object)"{\"a\" : \"b\", \"c\" : \"d=\"}").put((Object)"test.token.abc", (Object)"xyz").build());
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

