/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.spi.session.TestingSessionPropertyConfigurationManagerFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSessionPropertyDefaults {
    private static final ResourceGroupId TEST_RESOURCE_GROUP_ID = new ResourceGroupId("test");
    private static final NodeInfo TEST_NODE_INFO = new NodeInfo("test");

    @Test
    public void testApplyDefaultProperties() {
        SessionPropertyDefaults sessionPropertyDefaults = new SessionPropertyDefaults(TEST_NODE_INFO);
        TestingSessionPropertyConfigurationManagerFactory factory = new TestingSessionPropertyConfigurationManagerFactory((Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"override").put((Object)"system_default", (Object)"system_default").build(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"override").put((Object)"catalog_default", (Object)"catalog_default").build()));
        sessionPropertyDefaults.addConfigurationManagerFactory((SessionPropertyConfigurationManagerFactory)factory);
        sessionPropertyDefaults.setConfigurationManager(factory.getName(), (Map)ImmutableMap.of());
        Session session = Session.builder((SessionPropertyManager)new SessionPropertyManager()).setQueryId(new QueryId("test_query_id")).setIdentity(new Identity("testUser", Optional.empty())).setSystemProperty("query_max_memory", "1GB").setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "43").setCatalogSessionProperty("testCatalog", "explicit_set", "explicit_set").build();
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").build()));
        session = sessionPropertyDefaults.newSessionWithDefaultProperties(session, Optional.empty(), TEST_RESOURCE_GROUP_ID);
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").put((Object)"system_default", (Object)"system_default").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").put((Object)"catalog_default", (Object)"catalog_default").build()));
    }
}

