/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.airlift.jaxrs.JsonMapper;
import com.facebook.airlift.jaxrs.testing.JaxrsTestingHttpProcessor;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.TestQueryManager;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.remotetask.HttpRemoteTaskFactory;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.smile.SmileCodec;
import com.facebook.presto.server.smile.SmileCodecBinder;
import com.facebook.presto.server.smile.SmileModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.testing.TestingHandleResolver;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.testng.annotations.Test;

public class TestHttpRemoteTask {
    private static final Duration POLL_TIMEOUT = new Duration(100.0, TimeUnit.MILLISECONDS);
    private static final Duration IDLE_TIMEOUT = new Duration(3.0, TimeUnit.SECONDS);
    private static final Duration FAIL_TIMEOUT = new Duration(20.0, TimeUnit.SECONDS);
    private static final TaskManagerConfig TASK_MANAGER_CONFIG = new TaskManagerConfig().setStatusRefreshMaxWait(new Duration((double)(IDLE_TIMEOUT.roundTo(TimeUnit.MILLISECONDS) / 100L), TimeUnit.MILLISECONDS)).setInfoUpdateInterval(new Duration((double)(IDLE_TIMEOUT.roundTo(TimeUnit.MILLISECONDS) / 10L), TimeUnit.MILLISECONDS));
    private static final boolean TRACE_HTTP = false;

    @Test(timeOut=30000L)
    public void testRemoteTaskMismatch() throws Exception {
        this.runTest(FailureScenario.TASK_MISMATCH);
    }

    @Test(timeOut=30000L)
    public void testRejectedExecutionWhenVersionIsHigh() throws Exception {
        this.runTest(FailureScenario.TASK_MISMATCH_WHEN_VERSION_IS_HIGH);
    }

    @Test(timeOut=30000L)
    public void testRejectedExecution() throws Exception {
        this.runTest(FailureScenario.REJECTED_EXECUTION);
    }

    @Test(timeOut=30000L)
    public void testRegular() throws Exception {
        AtomicLong lastActivityNanos = new AtomicLong(System.nanoTime());
        TestingTaskResource testingTaskResource = new TestingTaskResource(lastActivityNanos, FailureScenario.NO_FAILURE);
        HttpRemoteTaskFactory httpRemoteTaskFactory = TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource);
        RemoteTask remoteTask = this.createRemoteTask(httpRemoteTaskFactory);
        testingTaskResource.setInitialTaskInfo(remoteTask.getTaskInfo());
        remoteTask.start();
        Lifespan lifespan = Lifespan.driverGroup((int)3);
        remoteTask.addSplits((Multimap)ImmutableMultimap.of((Object)TaskTestUtils.TABLE_SCAN_NODE_ID, (Object)new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit(), lifespan, SplitContext.NON_CACHEABLE)));
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID) != null);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).getSplits().size() == 1);
        remoteTask.noMoreSplits(TaskTestUtils.TABLE_SCAN_NODE_ID, lifespan);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).getNoMoreSplitsForLifespan().size() == 1);
        remoteTask.noMoreSplits(TaskTestUtils.TABLE_SCAN_NODE_ID);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).isNoMoreSplits());
        remoteTask.cancel();
        TestHttpRemoteTask.poll(() -> remoteTask.getTaskStatus().getState().isDone());
        TestHttpRemoteTask.poll(() -> remoteTask.getTaskInfo().getTaskStatus().getState().isDone());
        httpRemoteTaskFactory.stop();
    }

    private void runTest(FailureScenario failureScenario) throws Exception {
        AtomicLong lastActivityNanos = new AtomicLong(System.nanoTime());
        TestingTaskResource testingTaskResource = new TestingTaskResource(lastActivityNanos, failureScenario);
        HttpRemoteTaskFactory httpRemoteTaskFactory = TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource);
        RemoteTask remoteTask = this.createRemoteTask(httpRemoteTaskFactory);
        testingTaskResource.setInitialTaskInfo(remoteTask.getTaskInfo());
        remoteTask.start();
        TestHttpRemoteTask.waitUntilIdle(lastActivityNanos);
        httpRemoteTaskFactory.stop();
        org.testng.Assert.assertTrue((boolean)remoteTask.getTaskStatus().getState().isDone(), (String)String.format("TaskStatus is not in a done state: %s", remoteTask.getTaskStatus()));
        ErrorCode actualErrorCode = ((ExecutionFailureInfo)Iterables.getOnlyElement((Iterable)remoteTask.getTaskStatus().getFailures())).getErrorCode();
        switch (failureScenario) {
            case TASK_MISMATCH: 
            case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                org.testng.Assert.assertTrue((boolean)remoteTask.getTaskInfo().getTaskStatus().getState().isDone(), (String)String.format("TaskInfo is not in a done state: %s", remoteTask.getTaskInfo()));
                Assert.assertEquals((Object)actualErrorCode, (Object)StandardErrorCode.REMOTE_TASK_MISMATCH.toErrorCode());
                break;
            }
            case REJECTED_EXECUTION: {
                Assert.assertEquals((Object)actualErrorCode, (Object)StandardErrorCode.REMOTE_TASK_ERROR.toErrorCode());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private RemoteTask createRemoteTask(HttpRemoteTaskFactory httpRemoteTaskFactory) {
        return httpRemoteTaskFactory.createRemoteTask(SessionTestUtils.TEST_SESSION, new TaskId("test", 1, 0, 2), new InternalNode("node-id", URI.create("http://fake.invalid/"), new NodeVersion("version"), false), TaskTestUtils.createPlanFragment(), (Multimap)ImmutableMultimap.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST), new NodeTaskMap.PartitionedSplitCountTracker(i -> {}), true, new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private static HttpRemoteTaskFactory createHttpRemoteTaskFactory(final TestingTaskResource testingTaskResource) throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new SmileModule(), new HandleJsonModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(JsonMapper.class);
                ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
                FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
                binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
                JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
                Multibinder.newSetBinder((Binder)binder, Type.class);
                SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(TaskStatus.class);
                SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(TaskInfo.class);
                SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(TaskUpdateRequest.class);
                SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(PlanFragment.class);
                SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(MetadataUpdates.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskStatus.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(PlanFragment.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MetadataUpdates.class);
                JsonBinder.jsonBinder((Binder)binder).addKeySerializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionSerializer.class);
                JsonBinder.jsonBinder((Binder)binder).addKeyDeserializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionDeserializer.class);
            }

            @Provides
            private HttpRemoteTaskFactory createHttpRemoteTaskFactory(JsonMapper jsonMapper, JsonCodec<TaskStatus> taskStatusJsonCodec, SmileCodec<TaskStatus> taskStatusSmileCodec, JsonCodec<TaskInfo> taskInfoJsonCodec, SmileCodec<TaskInfo> taskInfoSmileCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestJsonCodec, SmileCodec<TaskUpdateRequest> taskUpdateRequestSmileCodec, JsonCodec<PlanFragment> planFragmentJsonCodec, SmileCodec<PlanFragment> planFragmentSmileCodec, JsonCodec<MetadataUpdates> metadataUpdatesJsonCodec, SmileCodec<MetadataUpdates> metadataUpdatesSmileCodec) {
                JaxrsTestingHttpProcessor jaxrsTestingHttpProcessor = new JaxrsTestingHttpProcessor(URI.create("http://fake.invalid/"), new Object[]{testingTaskResource, jsonMapper});
                TestingHttpClient testingHttpClient = new TestingHttpClient((TestingHttpClient.Processor)jaxrsTestingHttpProcessor.setTrace(false));
                testingTaskResource.setHttpClient(testingHttpClient);
                return new HttpRemoteTaskFactory(new QueryManagerConfig(), TASK_MANAGER_CONFIG, (HttpClient)testingHttpClient, (LocationFactory)new TestSqlTaskManager.MockLocationFactory(), taskStatusJsonCodec, taskStatusSmileCodec, taskInfoJsonCodec, taskInfoSmileCodec, taskUpdateRequestJsonCodec, taskUpdateRequestSmileCodec, planFragmentJsonCodec, planFragmentSmileCodec, metadataUpdatesJsonCodec, metadataUpdatesSmileCodec, new RemoteTaskStats(), new InternalCommunicationConfig(), MetadataManager.createTestMetadataManager(), (QueryManager)new TestQueryManager());
            }
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().quiet().initialize();
        HandleResolver handleResolver = (HandleResolver)injector.getInstance(HandleResolver.class);
        handleResolver.addConnectorName("test", (ConnectorHandleResolver)new TestingHandleResolver());
        return (HttpRemoteTaskFactory)injector.getInstance(HttpRemoteTaskFactory.class);
    }

    private static void poll(BooleanSupplier success) throws InterruptedException {
        long failAt = System.nanoTime() + FAIL_TIMEOUT.roundTo(TimeUnit.NANOSECONDS);
        while (!success.getAsBoolean()) {
            long millisUntilFail = (failAt - System.nanoTime()) / 1000000L;
            if (millisUntilFail <= 0L) {
                throw new AssertionError((Object)String.format("Timeout of %s reached", FAIL_TIMEOUT));
            }
            Thread.sleep(Math.min(POLL_TIMEOUT.toMillis(), millisUntilFail));
        }
    }

    private static void waitUntilIdle(AtomicLong lastActivityNanos) throws InterruptedException {
        long startTimeNanos = System.nanoTime();
        while (true) {
            long millisSinceLastActivity = (System.nanoTime() - lastActivityNanos.get()) / 1000000L;
            long millisSinceStart = (System.nanoTime() - startTimeNanos) / 1000000L;
            long millisToIdleTarget = IDLE_TIMEOUT.toMillis() - millisSinceLastActivity;
            long millisToFailTarget = FAIL_TIMEOUT.toMillis() - millisSinceStart;
            if (millisToFailTarget < millisToIdleTarget) {
                throw new AssertionError((Object)String.format("Activity doesn't stop after %s", FAIL_TIMEOUT));
            }
            if (millisToIdleTarget < 0L) {
                return;
            }
            Thread.sleep(millisToIdleTarget);
        }
    }

    @Path(value="/task/{nodeId}")
    public static class TestingTaskResource {
        private static final UUID INITIAL_TASK_INSTANCE_ID = UUID.randomUUID();
        private static final UUID NEW_TASK_INSTANCE_ID = UUID.randomUUID();
        private final AtomicLong lastActivityNanos;
        private final FailureScenario failureScenario;
        private AtomicReference<TestingHttpClient> httpClient = new AtomicReference();
        private TaskInfo initialTaskInfo;
        private TaskStatus initialTaskStatus;
        private long version;
        private TaskState taskState;
        private long taskInstanceIdLeastSignificantBits = INITIAL_TASK_INSTANCE_ID.getLeastSignificantBits();
        private long taskInstanceIdMostSignificantBits = INITIAL_TASK_INSTANCE_ID.getMostSignificantBits();
        private long statusFetchCounter;
        Map<PlanNodeId, TaskSource> taskSourceMap = new HashMap<PlanNodeId, TaskSource>();

        public TestingTaskResource(AtomicLong lastActivityNanos, FailureScenario failureScenario) {
            this.lastActivityNanos = Objects.requireNonNull(lastActivityNanos, "lastActivityNanos is null");
            this.failureScenario = Objects.requireNonNull(failureScenario, "failureScenario is null");
        }

        public void setHttpClient(TestingHttpClient newValue) {
            this.httpClient.set(newValue);
        }

        @GET
        @Path(value="{taskId}")
        @Produces(value={"application/json"})
        public synchronized TaskInfo getTaskInfo(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo) {
            this.lastActivityNanos.set(System.nanoTime());
            return this.buildTaskInfo();
        }

        @POST
        @Path(value="{taskId}")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        public synchronized TaskInfo createOrUpdateTask(@PathParam(value="taskId") TaskId taskId, TaskUpdateRequest taskUpdateRequest, @Context UriInfo uriInfo) {
            for (TaskSource source : taskUpdateRequest.getSources()) {
                this.taskSourceMap.compute(source.getPlanNodeId(), (planNodeId, taskSource) -> taskSource == null ? source : taskSource.update(source));
            }
            this.lastActivityNanos.set(System.nanoTime());
            return this.buildTaskInfo();
        }

        public synchronized TaskSource getTaskSource(PlanNodeId planNodeId) {
            TaskSource source = this.taskSourceMap.get(planNodeId);
            if (source == null) {
                return null;
            }
            return new TaskSource(source.getPlanNodeId(), source.getSplits(), source.getNoMoreSplitsForLifespan(), source.isNoMoreSplits());
        }

        @GET
        @Path(value="{taskId}/status")
        @Produces(value={"application/json"})
        public synchronized TaskStatus getTaskStatus(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo) throws InterruptedException {
            this.lastActivityNanos.set(System.nanoTime());
            this.wait(maxWait.roundTo(TimeUnit.MILLISECONDS));
            return this.buildTaskStatus();
        }

        @DELETE
        @Path(value="{taskId}")
        @Produces(value={"application/json"})
        public synchronized TaskInfo deleteTask(@PathParam(value="taskId") TaskId taskId, @QueryParam(value="abort") @DefaultValue(value="true") boolean abort, @Context UriInfo uriInfo) {
            this.lastActivityNanos.set(System.nanoTime());
            this.taskState = abort ? TaskState.ABORTED : TaskState.CANCELED;
            return this.buildTaskInfo();
        }

        public void setInitialTaskInfo(TaskInfo initialTaskInfo) {
            this.initialTaskInfo = initialTaskInfo;
            this.initialTaskStatus = initialTaskInfo.getTaskStatus();
            this.taskState = this.initialTaskStatus.getState();
            this.version = this.initialTaskStatus.getVersion();
            switch (this.failureScenario) {
                case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                    this.version = 1000000L;
                    break;
                }
                case TASK_MISMATCH: 
                case REJECTED_EXECUTION: 
                case NO_FAILURE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private TaskInfo buildTaskInfo() {
            return new TaskInfo(this.initialTaskInfo.getTaskId(), this.buildTaskStatus(), this.initialTaskInfo.getLastHeartbeat(), this.initialTaskInfo.getOutputBuffers(), this.initialTaskInfo.getNoMoreSplits(), this.initialTaskInfo.getStats(), this.initialTaskInfo.isNeedsPlan(), this.initialTaskInfo.getMetadataUpdates());
        }

        private TaskStatus buildTaskStatus() {
            ++this.statusFetchCounter;
            switch (this.failureScenario) {
                case TASK_MISMATCH: 
                case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                    if (this.statusFetchCounter != 10L) break;
                    this.taskInstanceIdLeastSignificantBits = NEW_TASK_INSTANCE_ID.getLeastSignificantBits();
                    this.taskInstanceIdMostSignificantBits = NEW_TASK_INSTANCE_ID.getMostSignificantBits();
                    this.version = 0L;
                    break;
                }
                case REJECTED_EXECUTION: {
                    if (this.statusFetchCounter < 10L) break;
                    this.httpClient.get().close();
                    throw new RejectedExecutionException();
                }
                case NO_FAILURE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return new TaskStatus(this.taskInstanceIdLeastSignificantBits, this.taskInstanceIdMostSignificantBits, ++this.version, this.taskState, this.initialTaskStatus.getSelf(), (Set)ImmutableSet.of(), this.initialTaskStatus.getFailures(), this.initialTaskStatus.getQueuedPartitionedDrivers(), this.initialTaskStatus.getRunningPartitionedDrivers(), this.initialTaskStatus.getOutputBufferUtilization(), this.initialTaskStatus.isOutputBufferOverutilized(), this.initialTaskStatus.getPhysicalWrittenDataSizeInBytes(), this.initialTaskStatus.getMemoryReservationInBytes(), this.initialTaskStatus.getSystemMemoryReservationInBytes(), this.initialTaskStatus.getPeakNodeTotalMemoryReservationInBytes(), this.initialTaskStatus.getFullGcCount(), this.initialTaskStatus.getFullGcTimeInMillis());
        }
    }

    private static enum FailureScenario {
        NO_FAILURE,
        TASK_MISMATCH,
        TASK_MISMATCH_WHEN_VERSION_IS_HIGH,
        REJECTED_EXECUTION;

    }
}

