/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.airlift.json.JsonCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testng.Assert;

public class Person {
    private String name;
    private boolean rocks;
    private Optional<String> lastName;

    public static void validatePersonJsonCodec(JsonCodec<Person> jsonCodec) {
        Person expected = new Person().setName("dain").setRocks(true);
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertFalse((boolean)json.contains("lastName"));
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
        expected.setLastName(Optional.empty());
        json = jsonCodec.toJson((Object)expected);
        Assert.assertFalse((boolean)json.contains("lastName"));
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
        expected.setLastName(Optional.of("Awesome"));
        json = jsonCodec.toJson((Object)expected);
        Assert.assertTrue((boolean)json.contains("lastName"));
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
    }

    public static void validatePersonListJsonCodec(JsonCodec<List<Person>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Person().setName("dain").setRocks(true), (Object)new Person().setName("martin").setRocks(true), (Object)new Person().setName("mark").setRocks(true));
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(json)), (Collection)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(bytes)), (Collection)expected);
    }

    public static void validatePersonMapJsonCodec(JsonCodec<Map<String, Person>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"dain", (Object)new Person().setName("dain").setRocks(true)).put((Object)"martin", (Object)new Person().setName("martin").setRocks(true)).put((Object)"mark", (Object)new Person().setName("mark").setRocks(true)).build();
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(json)), (Map)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(bytes)), (Map)expected);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Person setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty
    public boolean isRocks() {
        return this.rocks;
    }

    @JsonProperty
    public Person setRocks(boolean rocks) {
        this.rocks = rocks;
        return this;
    }

    @JsonProperty
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @JsonProperty
    public void setLastName(Optional<String> lastName) {
        this.lastName = lastName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Person o = (Person)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.rocks, o.rocks);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rocks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("rocks", this.rocks).add("lastName", this.lastName).toString();
    }
}

