/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.FileSingleStreamSpiller;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SpillerStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestFileSingleStreamSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private final File tempDirectory = com.google.common.io.Files.createTempDir();

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdown();
        MoreFiles.deleteRecursively((Path)this.tempDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testSpill() throws Exception {
        this.assertSpill(false, false);
    }

    @Test
    public void testSpillCompression() throws Exception {
        this.assertSpill(true, false);
    }

    @Test
    public void testSpillEncryption() throws Exception {
        this.assertSpill(false, true);
    }

    @Test
    public void testSpillEncryptionWithCompression() throws Exception {
        this.assertSpill(true, true);
    }

    private void assertSpill(boolean compression, boolean encryption) throws Exception {
        File spillPath = new File(this.tempDirectory, UUID.randomUUID().toString());
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)new BlockEncodingManager(new BlockEncoding[0]), new SpillerStats(), (List)ImmutableList.of((Object)spillPath.toPath()), 1.0, compression, encryption);
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test");
        SingleStreamSpiller singleStreamSpiller = spillerFactory.create(TYPES, bytes -> {}, memoryContext);
        Assert.assertTrue((boolean)(singleStreamSpiller instanceof FileSingleStreamSpiller));
        FileSingleStreamSpiller spiller = (FileSingleStreamSpiller)singleStreamSpiller;
        Page page = this.buildPage();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        spiller.spill(page).get();
        spiller.spill((Iterator)Iterators.forArray((Object[])new Page[]{page, page, page})).get();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)spillPath.toPath()).size(), (int)1);
        try (InputStream is = Files.newInputStream((Path)MoreFiles.listFiles((Path)spillPath.toPath()).get(0), new OpenOption[0]);){
            Iterator serializedPages = PagesSerdeUtil.readSerializedPages((SliceInput)new InputStreamSliceInput(is));
            Assert.assertTrue((boolean)serializedPages.hasNext(), (String)"at least one page should be successfully read back");
            byte markers = ((SerializedPage)serializedPages.next()).getPageCodecMarkers();
            Assert.assertEquals((boolean)PageCodecMarker.COMPRESSED.isSet(markers), (boolean)compression);
            Assert.assertEquals((boolean)PageCodecMarker.ENCRYPTED.isSet(markers), (boolean)encryption);
        }
        Iterator spilledPagesIterator = spiller.getSpilledPages();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        ImmutableList spilledPages = ImmutableList.copyOf((Iterator)spilledPagesIterator);
        Assert.assertEquals((int)4, (int)spilledPages.size());
        for (int i = 0; i < 4; ++i) {
            PageAssertions.assertPageEquals(TYPES, page, (Page)spilledPages.get(i));
        }
        spiller.close();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)spillPath.toPath()).size(), (int)0);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        return new Page(new Block[]{col1.build(), col2.build(), col3.build()});
    }
}

