/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionUtils {
    @Test
    public void testAnd() {
        Identifier a = TestExpressionUtils.name("a");
        Identifier b = TestExpressionUtils.name("b");
        Identifier c = TestExpressionUtils.name("c");
        Identifier d = TestExpressionUtils.name("d");
        Identifier e = TestExpressionUtils.name("e");
        Assert.assertEquals((Object)ExpressionUtils.and((Expression[])new Expression[]{a, b, c, d, e}), (Object)this.and((Expression)this.and((Expression)this.and((Expression)a, (Expression)b), (Expression)this.and((Expression)c, (Expression)d)), (Expression)e));
        Assert.assertEquals((Object)ExpressionUtils.combineConjuncts((Expression[])new Expression[]{a, b, a, c, d, c, e}), (Object)this.and((Expression)this.and((Expression)this.and((Expression)a, (Expression)b), (Expression)this.and((Expression)c, (Expression)d)), (Expression)e));
    }

    @Test
    public void testNormalize() {
        TestExpressionUtils.assertNormalize((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new IsNullPredicate((Expression)TestExpressionUtils.name("a")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new LikePredicate((Expression)TestExpressionUtils.name("a"), (Expression)new StringLiteral("x%"), Optional.empty())));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))));
    }

    private static void assertNormalize(Expression expression) {
        TestExpressionUtils.assertNormalize(expression, expression);
    }

    private static void assertNormalize(Expression expression, Expression normalized) {
        Assert.assertEquals((Object)ExpressionUtils.normalize((Expression)expression), (Object)normalized);
    }

    private static Identifier name(String name) {
        return new Identifier(name);
    }

    private LogicalBinaryExpression and(Expression left, Expression right) {
        return new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, left, right);
    }
}

