/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSqlToRowExpressionTranslator {
    private final TestingRowExpressionTranslator translator = new TestingRowExpressionTranslator();

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        LongLiteral expression = new LongLiteral("1");
        ImmutableMap.Builder types = ImmutableMap.builder();
        types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CoalesceExpression((Expression)expression, (Expression)new LongLiteral("2"), new Expression[0]);
            types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        }
        this.translator.translateAndOptimize((Expression)expression, (Map<NodeRef<Expression>, Type>)types.build());
    }

    @Test
    public void testOptimizeDecimalLiteral() {
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(7,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("DECIMAL '42'")), (Object)Expressions.constant((Object)42L, (Type)DecimalType.createDecimalType((int)2, (int)0)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))")), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(this.translator.simplifyExpression(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))"))), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(35,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("DECIMAL '123456789012345678901234567890'")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890")), (Type)DecimalType.createDecimalType((int)30, (int)0)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translator.translateAndOptimize(this.translator.simplifyExpression(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))"))), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
    }
}

