/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.NoOpVariableResolver;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariableResolver;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;

public class TestingRowExpressionTranslator {
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;

    public TestingRowExpressionTranslator(Metadata metadata) {
        this.metadata = metadata;
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
    }

    public TestingRowExpressionTranslator() {
        this((Metadata)MetadataManager.createTestMetadataManager());
    }

    public RowExpression translateAndOptimize(Expression expression) {
        return this.translateAndOptimize(expression, this.getExpressionTypes(expression, TypeProvider.empty()));
    }

    public RowExpression translateAndOptimize(Expression expression, TypeProvider typeProvider) {
        return this.translateAndOptimize(expression, this.getExpressionTypes(expression, typeProvider));
    }

    public RowExpression translate(String sql, Map<String, Type> types) {
        return this.translate(ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql)), TypeProvider.viewOf(types));
    }

    public RowExpression translate(Expression expression, TypeProvider typeProvider) {
        return SqlToRowExpressionTranslator.translate((Expression)expression, this.getExpressionTypes(expression, typeProvider), (Map)ImmutableMap.of(), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)SessionTestUtils.TEST_SESSION);
    }

    public RowExpression translateAndOptimize(Expression expression, Map<NodeRef<Expression>, Type> types) {
        RowExpression rowExpression = SqlToRowExpressionTranslator.translate((Expression)expression, types, (Map)ImmutableMap.of(), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)SessionTestUtils.TEST_SESSION);
        RowExpressionOptimizer optimizer = new RowExpressionOptimizer(this.metadata);
        return optimizer.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED, SessionTestUtils.TEST_SESSION.toConnectorSession());
    }

    Expression simplifyExpression(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression, TypeProvider.empty());
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer((Expression)expression, (Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, expressionTypes);
        Object value = interpreter.optimize((VariableResolver)NoOpVariableResolver.INSTANCE);
        return this.literalEncoder.toExpression(value, expressionTypes.get(NodeRef.of((Node)expression)));
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression, TypeProvider typeProvider) {
        ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (TypeManager)this.metadata.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (TypeProvider)typeProvider, Collections.emptyList(), node -> new IllegalStateException("Unexpected node: %s" + node), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        expressionAnalyzer.analyze(expression, Scope.create());
        return expressionAnalyzer.getExpressionTypes();
    }
}

