/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.operator.project.TestPageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPageProcessor {
    @Benchmark
    public Page handCoded(BenchmarkData data) {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE));
        int count = data.handcodedProcessor.process(data.inputPage, 0, data.inputPage.getPositionCount(), pageBuilder);
        Preconditions.checkState((count == data.inputPage.getPositionCount() ? 1 : 0) != 0);
        return pageBuilder.build();
    }

    @Test
    public void verifyHandCoded() {
        BenchmarkData benchmarkData = new BenchmarkData();
        benchmarkData.setup();
        BenchmarkPageProcessor benchmarkPageProcessor = new BenchmarkPageProcessor();
        benchmarkPageProcessor.handCoded(benchmarkData);
    }

    @Benchmark
    public List<Optional<Page>> compiled(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.compiledProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.inputPage));
    }

    @Test
    public void verifyCompiled() {
        BenchmarkData benchmarkData = new BenchmarkData();
        benchmarkData.setup();
        BenchmarkPageProcessor benchmarkPageProcessor = new BenchmarkPageProcessor();
        benchmarkPageProcessor.compiled(benchmarkData);
    }

    @Benchmark
    public List<Optional<Page>> identityProjection(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.identityProjectionProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.inputPage));
    }

    @Test
    public void verifyIdentityProjection() {
        BenchmarkData benchmarkData = new BenchmarkData();
        benchmarkData.setup();
        BenchmarkPageProcessor benchmarkPageProcessor = new BenchmarkPageProcessor();
        benchmarkPageProcessor.identityProjection(benchmarkData);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkPageProcessor.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int EXTENDED_PRICE = 0;
        private static final int DISCOUNT = 1;
        private static final int SHIP_DATE = 2;
        private static final int QUANTITY = 3;
        private static final int EXTENDED_PRICE_IN_CENTS = 4;
        private static final int DISCOUNT_PERCENT = 5;
        private static final int POSITION_COUNT = 10000;
        private static final Slice MIN_SHIP_DATE = Slices.utf8Slice((String)"1994-01-01");
        private static final Slice MAX_SHIP_DATE = Slices.utf8Slice((String)"1995-01-01");
        private MetadataManager metadataManager = MetadataManager.createTestMetadataManager();
        private FunctionAndTypeManager functionManager = this.metadataManager.getFunctionAndTypeManager();
        private PageProcessor compiledProcessor;
        private Tpch1FilterAndProject handcodedProcessor;
        private PageProcessor identityProjectionProcessor;
        private Page inputPage;
        @Param(value={"always", "never", "partial"})
        private String filterFails = "partial";
        @Param(value={"BIGINT", "DOUBLE"})
        private String projectionDataType = "DOUBLE";

        @Setup
        public void setup() {
            this.inputPage = BenchmarkData.createInputPage();
            this.compiledProcessor = (PageProcessor)new ExpressionCompiler((Metadata)this.metadataManager, new PageFunctionCompiler((Metadata)this.metadataManager, 0)).compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.of(this.createFilterExpression(this.functionManager)), (List)ImmutableList.of((Object)this.createProjectExpression(this.functionManager))).get();
            this.handcodedProcessor = new Tpch1FilterAndProject();
            this.identityProjectionProcessor = this.createIndentityProjectionPageProcessor();
        }

        private static Page createInputPage() {
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
            Iterator iterator = lineItemGenerator.iterator();
            for (int i = 0; i < 10000; ++i) {
                pageBuilder.declarePosition();
                LineItem lineItem = (LineItem)iterator.next();
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
                DateType.DATE.writeLong(pageBuilder.getBlockBuilder(2), (long)lineItem.getShipDate());
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.getQuantity());
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(4), lineItem.getExtendedPriceInCents());
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(5), lineItem.getDiscountPercent());
            }
            return pageBuilder.build();
        }

        private final RowExpression createFilterExpression(FunctionAndTypeManager functionAndTypeManager) {
            if (this.filterFails.equals("never")) {
                return new ConstantExpression((Object)true, (Type)BooleanType.BOOLEAN);
            }
            if (this.filterFails.equals("always")) {
                return Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MIN_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.LESS_THAN.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MAX_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE)}), Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.LESS_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.07, (Type)DoubleType.DOUBLE)}), Expressions.call((String)OperatorType.LESS_THAN.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)DoubleType.DOUBLE), Expressions.constant((Object)24.0, (Type)DoubleType.DOUBLE)})})})})});
            }
            return Expressions.call((String)OperatorType.GREATER_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE)});
        }

        private final RowExpression createProjectExpression(FunctionAndTypeManager functionAndTypeManager) {
            switch (this.projectionDataType) {
                case "BIGINT": {
                    return Expressions.call((String)OperatorType.MULTIPLY.name(), (FunctionHandle)functionAndTypeManager.resolveOperator(OperatorType.MULTIPLY, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)4, (Type)BigintType.BIGINT), Expressions.field((int)5, (Type)BigintType.BIGINT)});
                }
                case "DOUBLE": {
                    return Expressions.call((String)OperatorType.MULTIPLY.name(), (FunctionHandle)functionAndTypeManager.resolveOperator(OperatorType.MULTIPLY, TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)DoubleType.DOUBLE), Expressions.field((int)1, (Type)DoubleType.DOUBLE)});
                }
            }
            return null;
        }

        private PageProcessor createIndentityProjectionPageProcessor() {
            TestPageProcessor.TestingPageFilter filter;
            if (this.filterFails.equals("always")) {
                filter = new TestPageProcessor.TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)0));
            } else if (this.filterFails.equals("never")) {
                filter = new TestPageProcessor.TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)10000));
            } else {
                int[] positions = IntStream.range(0, 5000).map(x -> x * 2).toArray();
                filter = new TestPageProcessor.TestingPageFilter(SelectedPositions.positionsList((int[])positions, (int)0, (int)5000));
            }
            return new PageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, this.metadataManager.getType(TypeSignature.parseTypeSignature((String)this.projectionDataType)), 0)), OptionalInt.of(8192));
        }

        private PageProjectionWithOutputs createInputPageProjectionWithOutputs(int inputChannel, Type type, int outputChannel) {
            return new PageProjectionWithOutputs((PageProjection)new InputPageProjection(inputChannel), new int[]{outputChannel});
        }

        private final class Tpch1FilterAndProject {
            private Tpch1FilterAndProject() {
            }

            public int process(Page page, int start, int end, PageBuilder pageBuilder) {
                int position;
                Block discountBlock = page.getBlock(1);
                for (position = start; position < end; ++position) {
                    if (!this.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                    this.project(position, pageBuilder, page.getBlock(0), discountBlock);
                }
                return position;
            }

            private void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
                pageBuilder.declarePosition();
                if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(0).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
                }
            }

            private boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
                if (BenchmarkData.this.filterFails.equals("never")) {
                    return true;
                }
                if (BenchmarkData.this.filterFails.equals("always")) {
                    return !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MIN_SHIP_DATE) >= 0 && !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MAX_SHIP_DATE) < 0 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && DoubleType.DOUBLE.getDouble(quantityBlock, position) < 24.0;
                }
                return !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05;
            }
        }
    }
}

