/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageFunctionCompiler {
    private static final FunctionAndTypeManager FUNCTION_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final CallExpression ADD_10_EXPRESSION = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
    private static final CallExpression ADD_X_Y = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.field((int)1, (Type)BigintType.BIGINT)});
    private static final CallExpression ADD_X_Y_GREATER_THAN_2 = Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.GREATER_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{ADD_X_Y, Expressions.constant((Object)2L, (Type)BigintType.BIGINT)});
    private static final CallExpression ADD_X_Y_LESS_THAN_10 = Expressions.call((String)OperatorType.LESS_THAN.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{ADD_X_Y, Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
    private static final CallExpression ADD_X_Y_Z = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.field((int)1, (Type)BigintType.BIGINT)}), Expressions.field((int)2, (Type)BigintType.BIGINT)});

    @Test
    public void testFailureDoesNotCorruptFutureResults() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Supplier projectionSupplier = functionCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page goodPage = TestPageFunctionCompiler.createLongBlockPage(1, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        Block goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount())).get(0);
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
        Page badPage = TestPageFunctionCompiler.createLongBlockPage(1, 0L, 1L, 2L, 3L, 4L, Long.MAX_VALUE);
        try {
            this.project(projection, badPage, SelectedPositions.positionsRange((int)0, (int)100));
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode());
        }
        goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount())).get(0);
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
    }

    @Test
    public void testGeneratedClassName() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        String planNodeId = "7";
        String stageId = "20170707_223500_67496_zguwn.2";
        String classSuffix = stageId + "_" + planNodeId;
        Supplier projectionSupplier = functionCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of(classSuffix));
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Work work = projection.project(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), TestPageFunctionCompiler.createLongBlockPage(1, 0L), SelectedPositions.positionsRange((int)0, (int)1));
        Assert.assertTrue((boolean)work.getClass().getSimpleName().startsWith("PageProjectionWork_" + stageId.replace('.', '_') + "_" + planNodeId));
    }

    @Test
    public void testCache() {
        PageFunctionCompiler cacheCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 100);
        Assert.assertSame((Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertSame((Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertSame((Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertSame((Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        PageFunctionCompiler noCacheCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
    }

    @Test
    public void testCommonSubExpressionInProjection() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        List pageProjectionsCSE = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (List)ImmutableList.of((Object)ADD_X_Y, (Object)ADD_X_Y_Z), true, Optional.empty());
        Assert.assertEquals((int)pageProjectionsCSE.size(), (int)1);
        List pageProjectionsNoCSE = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (List)ImmutableList.of((Object)ADD_X_Y, (Object)ADD_X_Y_Z), false, Optional.empty());
        Assert.assertEquals((int)pageProjectionsNoCSE.size(), (int)2);
        Page input = TestPageFunctionCompiler.createLongBlockPage(3, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        List<Block> cseResult = this.project(((PageProjectionWithOutputs)((Supplier)pageProjectionsCSE.get(0)).get()).getPageProjection(), input, SelectedPositions.positionsRange((int)0, (int)input.getPositionCount()));
        Assert.assertEquals((int)cseResult.size(), (int)2);
        List<Block> noCseResult1 = this.project(((PageProjectionWithOutputs)((Supplier)pageProjectionsNoCSE.get(0)).get()).getPageProjection(), input, SelectedPositions.positionsRange((int)0, (int)input.getPositionCount()));
        Assert.assertEquals((int)noCseResult1.size(), (int)1);
        List<Block> noCseResult2 = this.project(((PageProjectionWithOutputs)((Supplier)pageProjectionsNoCSE.get(1)).get()).getPageProjection(), input, SelectedPositions.positionsRange((int)0, (int)input.getPositionCount()));
        Assert.assertEquals((int)noCseResult2.size(), (int)1);
        this.checkBlockEqual(cseResult.get(0), noCseResult1.get(0));
        this.checkBlockEqual(cseResult.get(1), noCseResult2.get(0));
    }

    @Test
    public void testCommonSubExpressionLongProjectionList() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        List pageProjections = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), this.createIfProjectionList(5), true, Optional.empty());
        Assert.assertEquals((int)pageProjections.size(), (int)1);
        pageProjections = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), this.createIfProjectionList(10), true, Optional.empty());
        Assert.assertEquals((int)pageProjections.size(), (int)1);
        pageProjections = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), this.createIfProjectionList(11), true, Optional.empty());
        Assert.assertEquals((int)pageProjections.size(), (int)2);
        pageProjections = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), this.createIfProjectionList(20), true, Optional.empty());
        Assert.assertEquals((int)pageProjections.size(), (int)2);
        pageProjections = functionCompiler.compileProjections(TestingConnectorSession.SESSION.getSqlFunctionProperties(), this.createIfProjectionList(101), true, Optional.empty());
        Assert.assertEquals((int)pageProjections.size(), (int)11);
    }

    @Test
    public void testCommonSubExpressionInFilter() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Supplier pageFilter = functionCompiler.compileFilter(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)new SpecialFormExpression(SpecialFormExpression.Form.AND, (Type)BigintType.BIGINT, new RowExpression[]{ADD_X_Y_GREATER_THAN_2, ADD_X_Y_LESS_THAN_10}), true, Optional.empty());
        Page input = TestPageFunctionCompiler.createLongBlockPage(2, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        SelectedPositions positions = this.filter((PageFilter)pageFilter.get(), input);
        Assert.assertEquals((int)positions.size(), (int)3);
        Assert.assertEquals((Object)positions.getPositions(), (Object)new int[]{2, 3, 4});
    }

    private void checkBlockEqual(Block a, Block b) {
        Assert.assertEquals((int)a.getPositionCount(), (int)b.getPositionCount());
        for (int i = 0; i < a.getPositionCount(); ++i) {
            Assert.assertEquals((long)a.getLong(i), (long)b.getLong(i));
        }
    }

    private List<Block> project(PageProjection projection, Page page, SelectedPositions selectedPositions) {
        Work work = projection.project(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), page, selectedPositions);
        Assert.assertTrue((boolean)work.process());
        return (List)work.getResult();
    }

    private SelectedPositions filter(PageFilter filter, Page page) {
        return filter.filter(TestingConnectorSession.SESSION.getSqlFunctionProperties(), filter.getInputChannels().getInputChannels(page));
    }

    private static Page createLongBlockPage(int blockCount, long ... values) {
        Block[] blocks = new Block[blockCount];
        for (int i = 0; i < blockCount; ++i) {
            BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.length);
            for (long value : values) {
                BigintType.BIGINT.writeLong(builder, value);
            }
            blocks[i] = builder.build();
        }
        return new Page(blocks);
    }

    private List<? extends RowExpression> createIfProjectionList(int projectionCount) {
        return (List)IntStream.range(0, projectionCount).mapToObj(i -> new SpecialFormExpression(SpecialFormExpression.Form.IF, (Type)BigintType.BIGINT, new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)FUNCTION_MANAGER.resolveOperator(OperatorType.GREATER_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)}), Expressions.constant((Object)i, (Type)BigintType.BIGINT), Expressions.constant((Object)((long)i + 1L), (Type)BigintType.BIGINT)})).collect(ImmutableList.toImmutableList());
    }
}

