/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.CanonicalPartitioningScheme;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.CanonicalTableScanNode;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCanonicalPlanGenerator
extends BasePlanTest {
    @Test
    public void testPartialAggregation() {
        this.assertSameCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT avg(totalprice) FILTER (WHERE orderstatus != 'F') FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT array_agg(totalprice ORDER BY totalprice) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT DISTINCT orderstatus FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority, custkey), (shippriority)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY CUBE (shippriority, custkey)");
        this.assertSameCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders", "SELECT sum(totalprice) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FROM orders", "SELECT avg(shippriority) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT count(orderkey) FROM orders", "SELECT count(orderkey) FROM lineitem");
        this.assertDifferentCanonicalLeafSubPlan("SELECT avg(totalprice) FILTER (WHERE orderstatus != 'F') FROM orders", "SELECT avg(totalprice) FILTER (WHERE orderstatus != 'P') FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT array_agg(totalprice ORDER BY orderstatus) FROM orders", "SELECT array_agg(totalprice ORDER BY totalprice) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT DISTINCT orderstatus FROM orders", "SELECT DISTINCT totalprice FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT count(DISTINCT orderstatus) FROM orders", "SELECT count(orderstatus) FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", "SELECT shippriority, sum(totalprice) FROM orders GROUP BY shippriority");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (shippriority), (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS (custkey), (shippriority, custkey)");
        this.assertDifferentCanonicalLeafSubPlan("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (shippriority, custkey)", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY ROLLUP (custkey, shippriority)");
    }

    @Test
    public void testProject() {
        this.assertSameCanonicalLeafSubPlan("SELECT 1 + 2 FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice / 2 FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT custkey + orderkey FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice / 2 FROM orders", "SELECT totalprice * 2 FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT custkey + orderkey FROM orders", "SELECT custkey + shippriority FROM orders");
    }

    @Test
    public void testFilter() {
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100", "SELECT totalprice FROM orders WHERE orderkey < 50");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders WHERE orderkey < 100", "SELECT totalprice FROM orders WHERE custkey < 100");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders", "SELECT totalprice FROM orders WHERE custkey < 100");
    }

    @Test
    public void testTableScan() {
        this.assertSameCanonicalLeafSubPlan("SELECT totalprice FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT orderkey, totalprice FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT * FROM orders");
        this.assertSameCanonicalLeafSubPlan("SELECT * FROM orders", "SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT totalprice FROM orders", "SELECT orderkey, totalprice FROM orders");
        this.assertDifferentCanonicalLeafSubPlan("SELECT * FROM orders", "SELECT orderkey, totalprice FROM orders");
    }

    private static List<SubPlan> getLeafSubPlans(SubPlan subPlan) {
        if (subPlan.getChildren().isEmpty()) {
            return ImmutableList.of((Object)subPlan);
        }
        return (List)subPlan.getChildren().stream().map(TestCanonicalPlanGenerator::getLeafSubPlans).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private void assertSameCanonicalLeafSubPlan(String sql) {
        this.assertSameCanonicalLeafSubPlan(sql, sql);
    }

    private void assertSameCanonicalLeafSubPlan(String sql1, String sql2) {
        SubPlan subplan = this.subplan(String.format("( %s ) UNION ALL ( %s )", sql1, sql2), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false);
        List leafCanonicalPlans = TestCanonicalPlanGenerator.getLeafSubPlans(subplan).stream().map(SubPlan::getFragment).map(fragment -> CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment.getRoot(), (PartitioningScheme)fragment.getPartitioningScheme())).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals((int)leafCanonicalPlans.size(), (int)2);
        Assert.assertEquals(leafCanonicalPlans.get(0), leafCanonicalPlans.get(1));
    }

    private void assertDifferentCanonicalLeafSubPlan(String sql1, String sql2) {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment1.getRoot(), (PartitioningScheme)fragment1.getPartitioningScheme());
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment2.getRoot(), (PartitioningScheme)fragment2.getPartitioningScheme());
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertNotEquals((Object)canonicalPlan1, (Object)canonicalPlan2);
    }

    @Test
    public void testCanonicalPartitioningScheme() {
        Assert.assertEquals((Set)((Set)Arrays.stream(PartitioningScheme.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"partitioning", (Object)"outputLayout", (Object)"hashColumn", (Object)"replicateNullsAndAny", (Object)"bucketToPartition"));
        Assert.assertEquals((Set)((Set)Arrays.stream(Partitioning.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"handle", (Object)"arguments"));
        Assert.assertEquals((Set)((Set)Arrays.stream(PartitioningHandle.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"transactionHandle", (Object)"connectorHandle"));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalPartitioningScheme.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"connectorHandle", (Object)"arguments", (Object)"outputLayout"));
    }

    @Test
    public void testCanonicalTableScanNodeField() {
        Assert.assertEquals((Set)((Set)Arrays.stream(TableScanNode.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"table", (Object)"assignments", (Object)"outputVariables", (Object)"currentConstraint", (Object)"enforcedConstraint"));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalTableScanNode.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"table", (Object)"assignments", (Object)"outputVariables"));
        Assert.assertEquals((Set)((Set)Arrays.stream(TableHandle.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"connectorHandle", (Object)"transaction", (Object)"layout", (Object)"dynamicFilter"));
        Assert.assertEquals((Set)((Set)Arrays.stream(CanonicalTableScanNode.CanonicalTableHandle.class.getDeclaredFields()).map(Field::getName).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"connectorId", (Object)"connectorHandle", (Object)"layoutIdentifier"));
    }
}

