/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.SortExpressionExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortExpressionExtractor {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator(METADATA);
    private static final Set<VariableReferenceExpression> BUILD_VARIABLES = ImmutableSet.of((Object)new VariableReferenceExpression("b1", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("b2", (Type)BigintType.BIGINT));
    private static final TypeProvider TYPES = TypeProvider.fromVariables((Collection)ImmutableList.of((Object)new VariableReferenceExpression("b1", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("b2", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("p1", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("p2", (Type)BigintType.BIGINT)));

    @Test
    public void testGetSortExpression() {
        this.assertGetSortExpression("p1 > b1", "b1");
        this.assertGetSortExpression("b2 <= p1", "b2");
        this.assertGetSortExpression("b2 > p1", "b2");
        this.assertGetSortExpression("b2 > sin(p1)", "b2");
        this.assertNoSortExpression("b2 > random(p1)");
        this.assertGetSortExpression("b2 > random(p1) AND b2 > p1", "b2", "b2 > p1");
        this.assertGetSortExpression("b2 > random(p1) AND b1 > p1", "b1", "b1 > p1");
        this.assertNoSortExpression("b1 > p1 + b2");
        this.assertNoSortExpression("sin(b1) > p1");
        this.assertNoSortExpression("b1 <= p1 OR b2 <= p1");
        this.assertNoSortExpression("sin(b2) > p1 AND (b2 <= p1 OR b2 <= p1 + 10)");
        this.assertGetSortExpression("sin(b2) > p1 AND (b2 <= p1 AND b2 <= p1 + 10)", "b2", "b2 <= p1", "b2 <= p1 + 10");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1", "b1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1", "b1", "b1 > p1", "b1 <= p1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1 AND b2 < p1 + 10 AND b2 > p2", "b2", "b2 > p1", "b2 < p1 + 10", "b2 > p2");
    }

    private Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql));
    }

    private void assertNoSortExpression(String expression) {
        this.assertNoSortExpression(this.expression(expression));
    }

    private void assertNoSortExpression(Expression expression) {
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_VARIABLES, (RowExpression)TRANSLATOR.translate(expression, TYPES), (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager());
        Assert.assertEquals((Object)actual, Optional.empty());
    }

    private void assertGetSortExpression(String expression, String expectedSymbol) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol) {
        TestSortExpressionExtractor.assertGetSortExpression(expression, expectedSymbol, ExpressionUtils.extractConjuncts((Expression)expression));
    }

    private void assertGetSortExpression(String expression, String expectedSymbol, String ... searchExpressions) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol, searchExpressions);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, String ... searchExpressions) {
        List searchExpressionList = (List)Arrays.stream(searchExpressions).map(this::expression).collect(ImmutableList.toImmutableList());
        TestSortExpressionExtractor.assertGetSortExpression(expression, expectedSymbol, searchExpressionList);
    }

    private static void assertGetSortExpression(Expression expression, String expectedSymbol, List<Expression> searchExpressions) {
        Optional<SortExpressionContext> expected = Optional.of(new SortExpressionContext((RowExpression)new VariableReferenceExpression(expectedSymbol, (Type)BigintType.BIGINT), (List)searchExpressions.stream().map(e -> TRANSLATOR.translate((Expression)e, TYPES)).collect(ImmutableList.toImmutableList())));
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_VARIABLES, (RowExpression)TRANSLATOR.translate(expression, TYPES), (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager());
        Assert.assertEquals((Object)actual, expected);
    }
}

