/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;

    public AggregationFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "functionCall is null");
    }

    @Override
    public Optional<VariableReferenceExpression> getAssignedVariable(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Object> result = Optional.empty();
        if (!(node instanceof AggregationNode)) {
            return result;
        }
        AggregationNode aggregationNode = (AggregationNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        for (Map.Entry assignment : aggregationNode.getAggregations().entrySet()) {
            if (!AggregationFunctionMatcher.verifyAggregation(metadata.getFunctionAndTypeManager(), (AggregationNode.Aggregation)assignment.getValue(), expectedCall)) continue;
            Preconditions.checkState((!result.isPresent() ? 1 : 0) != 0, (String)"Ambiguous function calls in %s", (Object)aggregationNode);
            result = Optional.of(assignment.getKey());
        }
        return result;
    }

    private static boolean verifyAggregation(FunctionAndTypeManager functionAndTypeManager, AggregationNode.Aggregation aggregation, FunctionCall expectedCall) {
        return functionAndTypeManager.getFunctionMetadata(aggregation.getFunctionHandle()).getName().getFunctionName().equalsIgnoreCase(expectedCall.getName().getSuffix()) && aggregation.getArguments().size() == expectedCall.getArguments().size() && Streams.zip(aggregation.getArguments().stream(), expectedCall.getArguments().stream(), (actualArgument, expectedArgument) -> AggregationFunctionMatcher.isEquivalent(Optional.of(expectedArgument), Optional.of(actualArgument))).allMatch(Boolean::booleanValue) && AggregationFunctionMatcher.isEquivalent(expectedCall.getFilter(), aggregation.getFilter()) && expectedCall.isDistinct() == aggregation.isDistinct() && AggregationFunctionMatcher.verifyAggregationOrderBy(aggregation.getOrderBy(), expectedCall.getOrderBy());
    }

    private static boolean verifyAggregationOrderBy(Optional<OrderingScheme> orderingScheme, Optional<OrderBy> expectedSortOrder) {
        if (orderingScheme.isPresent() && expectedSortOrder.isPresent()) {
            return AggregationFunctionMatcher.verifyAggregationOrderBy(orderingScheme.get(), expectedSortOrder.get());
        }
        return orderingScheme.isPresent() == expectedSortOrder.isPresent();
    }

    private static boolean verifyAggregationOrderBy(OrderingScheme orderingScheme, OrderBy expectedSortOrder) {
        if (orderingScheme.getOrderByVariables().size() != expectedSortOrder.getSortItems().size()) {
            return false;
        }
        for (int i = 0; i < expectedSortOrder.getSortItems().size(); ++i) {
            VariableReferenceExpression orderingVariable = (VariableReferenceExpression)orderingScheme.getOrderByVariables().get(i);
            if (((SortItem)expectedSortOrder.getSortItems().get(i)).getSortKey().equals((Object)new SymbolReference(orderingVariable.getName())) && PlannerUtils.toSortOrder((SortItem)((SortItem)expectedSortOrder.getSortItems().get(i))).equals((Object)orderingScheme.getOrdering(orderingVariable))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEquivalent(Optional<Expression> expression, Optional<RowExpression> rowExpression) {
        if (rowExpression.isPresent() && expression.isPresent()) {
            if (OriginalExpressionUtils.isExpression((RowExpression)rowExpression.get())) {
                return expression.get().equals((Object)OriginalExpressionUtils.castToExpression((RowExpression)rowExpression.get()));
            }
            Preconditions.checkArgument((boolean)(rowExpression.get() instanceof VariableReferenceExpression), (Object)"can only process variableReference");
            return expression.get().equals((Object)new SymbolReference(((VariableReferenceExpression)rowExpression.get()).getName()));
        }
        return rowExpression.isPresent() == expression.isPresent();
    }

    public String toString() {
        return this.callMaker.toString();
    }
}

