/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.assertions.Util;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

final class ExchangeMatcher
implements Matcher {
    private final ExchangeNode.Scope scope;
    private final ExchangeNode.Type type;
    private final List<PlanMatchPattern.Ordering> orderBy;

    public ExchangeMatcher(ExchangeNode.Scope scope, ExchangeNode.Type type, List<PlanMatchPattern.Ordering> orderBy) {
        this.scope = scope;
        this.type = type;
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == this.scope && exchangeNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        ExchangeNode exchangeNode = (ExchangeNode)node;
        if (!this.orderBy.isEmpty()) {
            if (!exchangeNode.getOrderingScheme().isPresent()) {
                return MatchResult.NO_MATCH;
            }
            if (!Util.orderingSchemeMatches(this.orderBy, (OrderingScheme)exchangeNode.getOrderingScheme().get(), symbolAliases)) {
                return MatchResult.NO_MATCH;
            }
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scope", (Object)this.scope).add("type", (Object)this.type).add("orderBy", this.orderBy).toString();
    }
}

