/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class NotPlanNodeMatcher
implements Matcher {
    private final Class<? extends PlanNode> excludedNodeClass;

    NotPlanNodeMatcher(Class<? extends PlanNode> excludedNodeClass) {
        this.excludedNodeClass = Objects.requireNonNull(excludedNodeClass, "functionCalls is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return !node.getClass().equals(this.excludedNodeClass);
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("excludedNodeClass", this.excludedNodeClass).toString();
    }
}

