/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.testng.Assert;

public class OptimizerAssert {
    private final Metadata metadata;
    private final RuleAssert.TestingStatsCalculator statsCalculator;
    private final Session session;
    private final PlanOptimizer optimizer;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private TypeProvider types;
    private PlanNode plan;

    public OptimizerAssert(Metadata metadata, StatsCalculator statsCalculator, Session session, PlanOptimizer optimizer, TransactionManager transactionManager, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = new RuleAssert.TestingStatsCalculator(Objects.requireNonNull(statsCalculator, "statsCalculator is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.optimizer = Objects.requireNonNull(optimizer, "optimizer is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "access control is null");
    }

    public OptimizerAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Preconditions.checkState((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        PlanBuilder builder = new PlanBuilder(this.session, this.idAllocator, this.metadata);
        this.plan = planProvider.apply(builder);
        this.types = builder.getTypes();
        return this;
    }

    public void matches(PlanMatchPattern pattern) {
        PlanNode actual = this.optimizer.optimize(this.plan, this.session, this.types, new PlanVariableAllocator(), this.idAllocator, WarningCollector.NOOP);
        if (!ImmutableSet.copyOf((Collection)this.plan.getOutputVariables()).equals((Object)ImmutableSet.copyOf((Collection)actual.getOutputVariables()))) {
            Assert.fail((String)String.format("%s: output schema of transformed and original plans are not equivalent\n\texpected: %s\n\tactual:   %s", this.optimizer.getClass().getName(), this.plan.getOutputVariables(), actual.getOutputVariables()));
        }
        this.inTransaction(session -> {
            PlanAssert.assertPlan(session, this.metadata, this.statsCalculator, new Plan(actual, this.types, StatsAndCosts.empty()), pattern);
            return null;
        });
    }

    private <T> void inTransaction(Function<Session, T> transactionSessionConsumer) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }
}

