/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class Util {
    private Util() {
    }

    static boolean domainsMatch(Optional<Map<String, Domain>> expectedDomains, TupleDomain<ColumnHandle> actualConstraint, TableHandle tableHandle, Session session, Metadata metadata) {
        Optional actualDomains = actualConstraint.getDomains();
        if (expectedDomains.isPresent() != actualDomains.isPresent()) {
            return false;
        }
        if (!expectedDomains.isPresent()) {
            return true;
        }
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        for (Map.Entry<String, Domain> expectedColumnConstraint : expectedDomains.get().entrySet()) {
            if (!columnHandles.containsKey(expectedColumnConstraint.getKey())) {
                return false;
            }
            ColumnHandle columnHandle = (ColumnHandle)columnHandles.get(expectedColumnConstraint.getKey());
            if (!((Map)actualDomains.get()).containsKey(columnHandle)) {
                return false;
            }
            if (expectedColumnConstraint.getValue().contains((Domain)((Map)actualDomains.get()).get(columnHandle))) continue;
            return false;
        }
        return true;
    }

    static boolean orderingSchemeMatches(List<PlanMatchPattern.Ordering> expectedOrderBy, OrderingScheme orderingScheme, SymbolAliases symbolAliases) {
        if (expectedOrderBy.size() != orderingScheme.getOrderByVariables().size()) {
            return false;
        }
        for (int i = 0; i < expectedOrderBy.size(); ++i) {
            PlanMatchPattern.Ordering ordering = expectedOrderBy.get(i);
            Symbol symbol = Symbol.from((Expression)symbolAliases.get(ordering.getField()));
            if (!symbol.equals((Object)new Symbol(((VariableReferenceExpression)orderingScheme.getOrderByVariables().get(i)).getName()))) {
                return false;
            }
            SortOrder sortOrder = (SortOrder)Iterators.getOnlyElement(Maps.filterKeys((Map)orderingScheme.getOrderingsMap(), variable -> variable.getName().equals(symbol.getName())).values().iterator());
            if (ordering.getSortOrder().equals((Object)sortOrder)) continue;
            return false;
        }
        return true;
    }
}

