/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class WindowFrameProvider
implements ExpectedValueProvider<WindowNode.Frame> {
    private final WindowNode.Frame.WindowType type;
    private final WindowNode.Frame.BoundType startType;
    private final Optional<SymbolAlias> startValue;
    private final WindowNode.Frame.BoundType endType;
    private final Optional<SymbolAlias> endValue;

    WindowFrameProvider(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<SymbolAlias> startValue, WindowNode.Frame.BoundType endType, Optional<SymbolAlias> endValue) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startValue = Objects.requireNonNull(startValue, "startValue is null");
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endValue = Objects.requireNonNull(endValue, "endValue is null");
    }

    @Override
    public WindowNode.Frame getExpectedValue(SymbolAliases aliases) {
        Optional<Expression> originalStartValue = this.startValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        Optional<Expression> originalEndValue = this.endValue.map(alias -> alias.toSymbol(aliases).toSymbolReference());
        return new WindowNode.Frame(this.type, this.startType, this.startValue.map(alias -> new VariableReferenceExpression(alias.toSymbol(aliases).getName(), (Type)BigintType.BIGINT)), this.endType, this.endValue.map(alias -> new VariableReferenceExpression(alias.toSymbol(aliases).getName(), (Type)BigintType.BIGINT)), originalStartValue.map(Expression::toString), originalEndValue.map(Expression::toString));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startValue", this.startValue).add("endType", (Object)this.endType).add("endValue", this.endValue).toString();
    }
}

