/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WindowFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;
    private final Optional<FunctionHandle> functionHandle;
    private final Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker;

    public WindowFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker, Optional<FunctionHandle> functionHandle, Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "functionCall is null");
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        this.frameMaker = Objects.requireNonNull(frameMaker, "frameMaker is null");
    }

    @Override
    public Optional<VariableReferenceExpression> getAssignedVariable(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<VariableReferenceExpression> result = Optional.empty();
        if (!(node instanceof WindowNode)) {
            return result;
        }
        WindowNode windowNode = (WindowNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        Optional<WindowNode.Frame> expectedFrame = this.frameMaker.map(maker -> (WindowNode.Frame)maker.getExpectedValue(symbolAliases));
        List matchedOutputs = (List)windowNode.getWindowFunctions().entrySet().stream().filter(assignment -> {
            if (!expectedCall.getName().equals((Object)QualifiedName.of((String)metadata.getFunctionAndTypeManager().getFunctionMetadata(((WindowNode.Function)assignment.getValue()).getFunctionCall().getFunctionHandle()).getName().getFunctionName()))) {
                return false;
            }
            if (!this.functionHandle.map(((WindowNode.Function)assignment.getValue()).getFunctionHandle()::equals).orElse(true).booleanValue()) {
                return false;
            }
            if (!expectedFrame.map(arg_0 -> ((WindowNode.Frame)((WindowNode.Function)assignment.getValue()).getFrame()).equals(arg_0)).orElse(true).booleanValue()) {
                return false;
            }
            List expectedExpressions = expectedCall.getArguments();
            List actualExpressions = ((WindowNode.Function)assignment.getValue()).getFunctionCall().getArguments();
            if (expectedExpressions.size() != actualExpressions.size()) {
                return false;
            }
            for (int i = 0; i < expectedExpressions.size(); ++i) {
                Expression expectedExpression = (Expression)expectedExpressions.get(i);
                RowExpression actualExpression = (RowExpression)actualExpressions.get(i);
                if (!OriginalExpressionUtils.isExpression((RowExpression)actualExpression)) {
                    SymbolAliases.Builder builder = SymbolAliases.builder();
                    ImmutableSet.copyOf((Collection)VariablesExtractor.extractAllSymbols((Expression)expectedExpression)).forEach(symbol -> builder.put(symbol.getName(), symbol.toSymbolReference()));
                    if (((Boolean)new RowExpressionVerifier(builder.build(), metadata, session).process((Node)expectedExpression, actualExpression)).booleanValue()) continue;
                    return false;
                }
                if (expectedExpression.equals((Object)OriginalExpressionUtils.castToExpression((RowExpression)actualExpression))) continue;
                return false;
            }
            return true;
        }).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((matchedOutputs.size() <= 1 ? 1 : 0) != 0, (String)"Ambiguous function calls in %s", (Object)windowNode);
        if (matchedOutputs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matchedOutputs.get(0));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("callMaker", this.callMaker).add("functionHandle", this.functionHandle.orElse(null)).add("frameMaker", this.frameMaker.orElse(null)).toString();
    }
}

