/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.AliasMatcher;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SpecificationProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.assertions.WindowFunctionMatcher;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class WindowMatcher
implements Matcher {
    private final Optional<Set<SymbolAlias>> prePartitionedInputs;
    private final Optional<ExpectedValueProvider<WindowNode.Specification>> specification;
    private final Optional<Integer> preSortedOrderPrefix;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private WindowMatcher(Optional<Set<SymbolAlias>> prePartitionedInputs, Optional<ExpectedValueProvider<WindowNode.Specification>> specification, Optional<Integer> preSortedOrderPrefix, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.prePartitionedInputs = Objects.requireNonNull(prePartitionedInputs, "prePartitionedInputs is null");
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.preSortedOrderPrefix = Objects.requireNonNull(preSortedOrderPrefix, "preSortedOrderPrefix is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof WindowNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        WindowNode windowNode = (WindowNode)node;
        if (!this.prePartitionedInputs.map(expectedInputs -> ((ImmutableSet)expectedInputs.stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableSet.toImmutableSet())).equals(windowNode.getPrePartitionedInputs().stream().map(VariableReferenceExpression::getName).map(Symbol::new).collect(ImmutableSet.toImmutableSet()))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.specification.map(expectedSpecification -> SpecificationProvider.matchSpecification(windowNode.getSpecification(), (WindowNode.Specification)expectedSpecification.getExpectedValue(symbolAliases))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.preSortedOrderPrefix.map(windowNode.getPreSortedOrderPrefix()::equals).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.hashSymbol.map(expectedHashSymbol -> expectedHashSymbol.map(alias -> alias.toSymbol(symbolAliases)).map(Symbol::getName).equals(windowNode.getHashVariable().map(VariableReferenceExpression::getName))).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("prePartitionedInputs", this.prePartitionedInputs.orElse(null)).add("specification", this.specification.orElse(null)).add("preSortedOrderPrefix", this.preSortedOrderPrefix.orElse(null)).add("hashSymbol", this.hashSymbol.orElse(null)).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<Set<SymbolAlias>> prePartitionedInputs = Optional.empty();
        private Optional<ExpectedValueProvider<WindowNode.Specification>> specification = Optional.empty();
        private Optional<Integer> preSortedOrderPrefix = Optional.empty();
        private List<AliasMatcher> windowFunctionMatchers = new LinkedList<AliasMatcher>();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder prePartitionedInputs(Set<String> prePartitionedInputs) {
            Objects.requireNonNull(prePartitionedInputs, "prePartitionedInputs is null");
            this.prePartitionedInputs = Optional.of(prePartitionedInputs.stream().map(SymbolAlias::new).collect(ImmutableSet.toImmutableSet()));
            return this;
        }

        public Builder specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
            return this.specification(PlanMatchPattern.specification(partitionBy, orderBy, orderings));
        }

        public Builder specification(ExpectedValueProvider<WindowNode.Specification> specification) {
            Objects.requireNonNull(specification, "specification is null");
            this.specification = Optional.of(specification);
            return this;
        }

        public Builder preSortedOrderPrefix(int preSortedOrderPrefix) {
            this.preSortedOrderPrefix = Optional.of(preSortedOrderPrefix);
            return this;
        }

        public Builder addFunction(String outputAlias, ExpectedValueProvider<FunctionCall> functionCall) {
            return this.addFunction(Optional.of(outputAlias), functionCall);
        }

        public Builder addFunction(ExpectedValueProvider<FunctionCall> functionCall) {
            return this.addFunction(Optional.empty(), functionCall);
        }

        private Builder addFunction(Optional<String> outputAlias, ExpectedValueProvider<FunctionCall> functionCall) {
            this.windowFunctionMatchers.add(new AliasMatcher(outputAlias, new WindowFunctionMatcher(functionCall, Optional.empty(), Optional.empty())));
            return this;
        }

        public Builder addFunction(String outputAlias, ExpectedValueProvider<FunctionCall> functionCall, FunctionHandle functionHandle, ExpectedValueProvider<WindowNode.Frame> frame) {
            this.windowFunctionMatchers.add(new AliasMatcher(Optional.of(outputAlias), new WindowFunctionMatcher(functionCall, Optional.of(functionHandle), Optional.of(frame))));
            return this;
        }

        public Builder hashSymbol(String hashSymbol) {
            Objects.requireNonNull(hashSymbol, "hashSymbol is null");
            this.hashSymbol = Optional.of(Optional.of(new SymbolAlias(hashSymbol)));
            return this;
        }

        PlanMatchPattern build() {
            PlanMatchPattern result = PlanMatchPattern.node(WindowNode.class, this.source).with(new WindowMatcher(this.prePartitionedInputs, this.specification, this.preSortedOrderPrefix, this.hashSymbol));
            this.windowFunctionMatchers.forEach(result::with);
            return result;
        }
    }
}

