/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.Expression;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressionRewriter {
    @Test
    public void testRewriteIsNotNullPredicate() {
        TestCanonicalizeExpressionRewriter.assertRewritten("x is NOT NULL", "NOT (x IS NULL)");
    }

    @Test
    public void testRewriteIfExpression() {
        TestCanonicalizeExpressionRewriter.assertRewritten("IF(x = 0, 0, 1)", "CASE WHEN x = 0 THEN 0 ELSE 1 END");
    }

    @Test
    public void testRewriteCurrentTime() {
        TestCanonicalizeExpressionRewriter.assertRewritten("CURRENT_TIME", "\"current_time\"()");
    }

    @Test
    public void testRewriteYearExtract() {
        TestCanonicalizeExpressionRewriter.assertRewritten("EXTRACT(YEAR FROM '2017-07-20')", "year('2017-07-20')");
    }

    private static void assertRewritten(String from, String to) {
        Assert.assertEquals((Object)CanonicalizeExpressionRewriter.canonicalizeExpression((Expression)PlanBuilder.expression(from)), (Object)PlanBuilder.expression(to));
    }
}

