/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.EliminateCrossJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.joins.JoinGraph;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEliminateCrossJoins
extends BaseRuleTest {
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();

    public TestEliminateCrossJoins() {
        super(new Plugin[0]);
    }

    @Test
    public void testEliminateCrossJoin() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(this.variable("cyVariable"), this.variable("byVariable"))), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(this.variable("axVariable"), this.variable("cxVariable"))), PlanMatchPattern.any(new PlanMatchPattern[0]), PlanMatchPattern.any(new PlanMatchPattern[0])), PlanMatchPattern.any(new PlanMatchPattern[0])));
    }

    @Test
    public void testRetainOutgoingGroupReferences() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0]), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testDoNotReorderOuterJoin() {
        this.tester().assertThat((Rule)new EliminateCrossJoins()).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.LEFT)).doesNotFire();
    }

    @Test
    public void testIsOriginalOrder() {
        Assert.assertTrue((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4)));
        Assert.assertFalse((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)4)));
    }

    @Test
    public void testJoinOrder() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a")), (PlanNode)this.values(this.variable("b")), new VariableReferenceExpression[0]), (PlanNode)this.values(this.variable("c")), this.variable("a"), this.variable("c"), this.variable("c"), this.variable("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testJoinOrderWithRealCrossJoin() {
        JoinNode leftPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a")), (PlanNode)this.values(this.variable("b")), new VariableReferenceExpression[0]), (PlanNode)this.values(this.variable("c")), this.variable("a"), this.variable("c"), this.variable("c"), this.variable("b"));
        JoinNode rightPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("x")), (PlanNode)this.values(this.variable("y")), new VariableReferenceExpression[0]), (PlanNode)this.values(this.variable("z")), this.variable("x"), this.variable("z"), this.variable("z"), this.variable("y"));
        JoinNode plan = this.joinNode((PlanNode)leftPlan, (PlanNode)rightPlan, new VariableReferenceExpression[0]);
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)5, (Object)4));
    }

    @Test
    public void testJoinOrderWithMultipleEdgesBetweenNodes() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a")), (PlanNode)this.values(this.variable("b1"), this.variable("b2")), new VariableReferenceExpression[0]), (PlanNode)this.values(this.variable("c1"), this.variable("c2")), this.variable("a"), this.variable("c1"), this.variable("c1"), this.variable("b1"), this.variable("c2"), this.variable("b2"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testDonNotChangeOrderWithoutCrossJoin() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a")), (PlanNode)this.values(this.variable("b")), this.variable("a"), this.variable("b")), (PlanNode)this.values(this.variable("c")), this.variable("c"), this.variable("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testDoNotReorderCrossJoins() {
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a")), (PlanNode)this.values(this.variable("b")), new VariableReferenceExpression[0]), (PlanNode)this.values(this.variable("c")), this.variable("c"), this.variable("b"));
        JoinGraph joinGraph = (JoinGraph)Iterables.getOnlyElement((Iterable)JoinGraph.buildFrom((PlanNode)plan));
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testGiveUpOnNonIdentityProjections() {
        JoinNode plan = this.joinNode(this.projectNode((PlanNode)this.joinNode((PlanNode)this.values(this.variable("a1")), (PlanNode)this.values(this.variable("b")), new VariableReferenceExpression[0]), this.variable("a2"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("a1"))), (PlanNode)this.values(this.variable("c")), this.variable("a2"), this.variable("c"), this.variable("c"), this.variable("b"));
        Assert.assertEquals((int)JoinGraph.buildFrom((PlanNode)plan).size(), (int)2);
    }

    private Function<PlanBuilder, PlanNode> crossJoinAndJoin(JoinNode.Type secondJoinType) {
        return p -> {
            VariableReferenceExpression axVariable = p.variable("axVariable");
            VariableReferenceExpression byVariable = p.variable("byVariable");
            VariableReferenceExpression cxVariable = p.variable("cxVariable");
            VariableReferenceExpression cyVariable = p.variable("cyVariable");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.join(secondJoinType, (PlanNode)p.values(axVariable), (PlanNode)p.values(byVariable), new JoinNode.EquiJoinClause[0]), (PlanNode)p.values(cxVariable, cyVariable), new JoinNode.EquiJoinClause(p.variable(cxVariable), p.variable(axVariable)), new JoinNode.EquiJoinClause(p.variable(cyVariable), p.variable(byVariable)));
        };
    }

    private PlanNode projectNode(PlanNode source, VariableReferenceExpression variable, Expression expression) {
        return new ProjectNode(this.idAllocator.getNextId(), source, PlanBuilder.assignment(variable, expression));
    }

    private VariableReferenceExpression variable(String name) {
        return new VariableReferenceExpression(name, (Type)BigintType.BIGINT);
    }

    private JoinNode joinNode(PlanNode left, PlanNode right, VariableReferenceExpression ... variables) {
        Preconditions.checkArgument((variables.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < variables.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(variables[i], variables[i + 1]));
        }
        return new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, (List)criteria.build(), (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
    }

    private ValuesNode values(VariableReferenceExpression ... variables) {
        return new ValuesNode(this.idAllocator.getNextId(), Arrays.asList(variables), (List)ImmutableList.of());
    }
}

