/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestExpressionRewriteRuleSet
extends BaseRuleTest {
    private ExpressionRewriteRuleSet zeroRewriter = new ExpressionRewriteRuleSet((expression, context) -> new LongLiteral("0"));
    private static final FunctionCall nowCall = new FunctionCall(QualifiedName.of((String)"now"), (List)ImmutableList.of());
    private ExpressionRewriteRuleSet functionCallRewriter = new ExpressionRewriteRuleSet((expression, context) -> nowCall);
    private ExpressionRewriteRuleSet applyRewriter = new ExpressionRewriteRuleSet((expression, context) -> new InPredicate((Expression)new LongLiteral("0"), (Expression)new InListExpression((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2")))));

    public TestExpressionRewriteRuleSet() {
        super(new Plugin[0]);
    }

    @Test
    public void testProjectionExpressionRewrite() {
        this.tester().assertThat(this.zeroRewriter.projectExpressionRewrite()).on(p -> p.project(PlanBuilder.assignment(p.variable("y"), PlanBuilder.expression("x IS NOT NULL")), (PlanNode)p.values(p.variable("x")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"y", (Object)PlanMatchPattern.expression("0")), PlanMatchPattern.values("x")));
    }

    @Test
    public void testProjectionExpressionNotRewritten() {
        this.tester().assertThat(this.zeroRewriter.projectExpressionRewrite()).on(p -> p.project(PlanBuilder.assignment(p.variable("y"), PlanBuilder.expression("0")), (PlanNode)p.values(p.variable("x")))).doesNotFire();
    }

    @Test
    public void testAggregationExpressionRewrite() {
        this.tester().assertThat(new ExpressionRewriteRuleSet((expression, context) -> new SymbolReference("x")).aggregationExpressionRewrite()).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of((Object)new SymbolReference("y"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("x", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_1", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"x"))), PlanMatchPattern.values("x")));
    }

    @Test
    public void testAggregationExpressionNotRewritten() {
        this.tester().assertThat(this.functionCallRewriter.aggregationExpressionRewrite()).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.variable("count_1", (Type)DateType.DATE), (Expression)nowCall, (List<Type>)ImmutableList.of()).source((PlanNode)p.values()))).doesNotFire();
        this.tester().assertThat(this.functionCallRewriter.aggregationExpressionRewrite()).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.variable("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values()))).doesNotFire();
    }

    @Test
    public void testFilterExpressionRewrite() {
        this.tester().assertThat(this.zeroRewriter.filterExpressionRewrite()).on(p -> p.filter((Expression)new LongLiteral("1"), (PlanNode)p.values())).matches(PlanMatchPattern.filter("0", PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testFilterExpressionNotRewritten() {
        this.tester().assertThat(this.zeroRewriter.filterExpressionRewrite()).on(p -> p.filter((Expression)new LongLiteral("0"), (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testValueExpressionRewrite() {
        this.tester().assertThat(this.zeroRewriter.valuesExpressionRewrite()).on(p -> p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)OriginalExpressionUtils.castToRowExpression((Expression)PlanBuilder.expression("1")))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("0")))));
    }

    @Test
    public void testValueExpressionNotRewritten() {
        this.tester().assertThat(this.zeroRewriter.valuesExpressionRewrite()).on(p -> p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)OriginalExpressionUtils.castToRowExpression((Expression)PlanBuilder.expression("0")))))).doesNotFire();
    }

    @Test
    public void testApplyExpressionRewrite() {
        this.tester().assertThat(this.applyRewriter.applyExpressionRewrite()).on(p -> p.apply(PlanBuilder.assignment(p.variable("a", (Type)BigintType.BIGINT), (Expression)new InPredicate((Expression)new LongLiteral("1"), (Expression)new InListExpression((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"))))), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)p.values(), (PlanNode)p.values())).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("0 IN (1, 2)")), PlanMatchPattern.values(new String[0]), PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testApplyExpressionNotRewritten() {
        this.tester().assertThat(this.applyRewriter.applyExpressionRewrite()).on(p -> p.apply(PlanBuilder.assignment(p.variable("a", (Type)BigintType.BIGINT), (Expression)new InPredicate((Expression)new LongLiteral("0"), (Expression)new InListExpression((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"))))), (List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)p.values(), (PlanNode)p.values())).doesNotFire();
    }
}

