/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.execution.thrift.ThriftSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.InlineSqlFunctions;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestInlineSqlFunctions {
    private static final RoutineCharacteristics.Language JAVA = new RoutineCharacteristics.Language("java");
    private static final SqlInvokedFunction SQL_FUNCTION_SQUARE = new SqlInvokedFunction(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"square"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "square", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN x * x", Optional.empty());
    private static final SqlInvokedFunction THRIFT_FUNCTION_FOO = new SqlInvokedFunction(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"foo"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "thrift function foo", RoutineCharacteristics.builder().setLanguage(JAVA).setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", Optional.empty());
    private static final SqlInvokedFunction SQL_FUNCTION_ADD_1_TO_INT_ARRAY = new SqlInvokedFunction(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"add_1_int"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"array(int)"))), TypeSignature.parseTypeSignature((String)"array(int)"), "add 1 to all elements of array", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN transform(x, x -> x + 1)", Optional.empty());
    private static final SqlInvokedFunction SQL_FUNCTION_ADD_1_TO_BIGINT_ARRAY = new SqlInvokedFunction(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"add_1_bigint"), (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"array(bigint)"))), TypeSignature.parseTypeSignature((String)"array(bigint)"), "add 1 to all elements of array", RoutineCharacteristics.builder().setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "RETURN transform(x, x -> x + 1)", Optional.empty());
    private RuleTester tester;

    @BeforeTest
    public void setup() {
        RuleTester tester = new RuleTester();
        FunctionAndTypeManager functionAndTypeManager = tester.getMetadata().getFunctionAndTypeManager();
        functionAndTypeManager.addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL, (Object)JAVA, (Object)FunctionImplementationType.THRIFT), new ThriftSqlFunctionExecutor(null)), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql,java")));
        functionAndTypeManager.createFunction(SQL_FUNCTION_SQUARE, true);
        functionAndTypeManager.createFunction(THRIFT_FUNCTION_FOO, true);
        functionAndTypeManager.createFunction(SQL_FUNCTION_ADD_1_TO_INT_ARRAY, true);
        functionAndTypeManager.createFunction(SQL_FUNCTION_ADD_1_TO_BIGINT_ARRAY, true);
        this.tester = tester;
    }

    @Test
    public void testInlineFunction() {
        this.assertInlined(this.tester, "unittest.memory.square(x)", "x * x", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)IntegerType.INTEGER));
    }

    @Test
    public void testInlineFunctionInsideFunction() {
        this.assertInlined(this.tester, "abs(unittest.memory.square(x))", "abs(x * x)", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)IntegerType.INTEGER));
    }

    @Test
    public void testInlineFunctionContainingLambda() {
        this.assertInlined(this.tester, "unittest.memory.add_1_int(x)", "transform(x, x -> x + 1)", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testInlineSqlFunctionCoercesConstantWithCast() {
        this.assertInlined(this.tester, "unittest.memory.add_1_bigint(x)", "transform(x, x -> x + CAST(1 AS bigint))", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)new ArrayType((Type)BigintType.BIGINT)));
    }

    @Test
    public void testInlineBuiltinSqlFunction() {
        this.assertInlined(this.tester, "array_sum(x)", "reduce(x, BIGINT '0', (s, x) -> (s + coalesce(x, BIGINT '0')), (s -> s))", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testNoInlineThriftFunction() {
        this.assertInlined(this.tester, "unittest.memory.foo(x)", "unittest.memory.foo(x)", (Map<String, Type>)ImmutableMap.of((Object)"x", (Object)IntegerType.INTEGER));
    }

    @Test
    public void testInlineFunctionIntoPlan() {
        this.tester.assertThat(new InlineSqlFunctions(this.tester.getMetadata(), this.tester.getSqlParser()).projectExpressionRewrite()).on(p -> p.project(PlanBuilder.assignment(p.variable("squared"), (Expression)new FunctionCall(QualifiedName.of((String)"unittest", (String[])new String[]{"memory", "square"}), (List)ImmutableList.of((Object)new SymbolReference("a")))), (PlanNode)p.values(p.variable("a", (Type)IntegerType.INTEGER)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"squared", (Object)PlanMatchPattern.expression("x * x")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))));
    }

    @Test
    public void testNoInlineIntoPlanWhenInlineIsDisabled() {
        this.tester.assertThat(new InlineSqlFunctions(this.tester.getMetadata(), this.tester.getSqlParser()).projectExpressionRewrite()).setSystemProperty("inline_sql_functions", "false").on(p -> p.project(PlanBuilder.assignment(p.variable("squared"), (Expression)new FunctionCall(QualifiedName.of((String)"unittest", (String[])new String[]{"memory", "square"}), (List)ImmutableList.of((Object)new SymbolReference("a")))), (PlanNode)p.values(p.variable("a", (Type)IntegerType.INTEGER)))).doesNotFire();
    }

    private void assertInlined(RuleTester tester, String inputSql, String expected, Map<String, Type> variableTypes) {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("inline_sql_functions", "true").build();
        Metadata metadata = tester.getMetadata();
        Expression inputSqlExpression = PlanBuilder.expression(inputSql);
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)session, (Metadata)metadata, (SqlParser)tester.getSqlParser(), (TypeProvider)TypeProvider.viewOf(variableTypes), (Expression)inputSqlExpression, (List)ImmutableList.of(), (WarningCollector)WarningCollector.NOOP);
        Expression inlinedExpression = InlineSqlFunctions.InlineSqlFunctionsRewriter.rewrite((Expression)inputSqlExpression, (Session)session, (Metadata)metadata, (Map)expressionTypes);
        inlinedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)inlinedExpression);
        Expression expectedExpression = PlanBuilder.expression(expected);
        Assert.assertEquals((Object)inlinedExpression, (Object)expectedExpression);
    }
}

