/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneMarkDistinctColumns
extends BaseRuleTest {
    public TestPruneMarkDistinctColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testMarkerSymbolNotReferenced() {
        this.tester().assertThat((Rule)new PruneMarkDistinctColumns()).on(p -> {
            VariableReferenceExpression key = p.variable("key");
            VariableReferenceExpression key2 = p.variable("key2");
            VariableReferenceExpression mark = p.variable("mark");
            VariableReferenceExpression unused = p.variable("unused");
            return p.project(PlanBuilder.assignment(key2, (Expression)OriginalExpressionUtils.asSymbolReference((VariableReferenceExpression)key)), (PlanNode)p.markDistinct(mark, (List<VariableReferenceExpression>)ImmutableList.of((Object)key), (PlanNode)p.values(key, unused)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key2", (Object)PlanMatchPattern.expression("key")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"unused"))));
    }

    @Test
    public void testSourceSymbolNotReferenced() {
        this.tester().assertThat((Rule)new PruneMarkDistinctColumns()).on(p -> {
            VariableReferenceExpression key = p.variable("key");
            VariableReferenceExpression mark = p.variable("mark");
            VariableReferenceExpression hash = p.variable("hash");
            VariableReferenceExpression unused = p.variable("unused");
            return p.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{mark}), (PlanNode)p.markDistinct(mark, (List<VariableReferenceExpression>)ImmutableList.of((Object)key), hash, (PlanNode)p.values(key, hash, unused)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mark", (Object)PlanMatchPattern.expression("mark")), PlanMatchPattern.markDistinct("mark", (List<String>)ImmutableList.of((Object)"key"), "hash", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key", (Object)PlanMatchPattern.expression("key"), (Object)"hash", (Object)PlanMatchPattern.expression("hash")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"hash", (Object)"unused"))))));
    }

    @Test
    public void testKeySymbolNotReferenced() {
        this.tester().assertThat((Rule)new PruneMarkDistinctColumns()).on(p -> {
            VariableReferenceExpression key = p.variable("key");
            VariableReferenceExpression mark = p.variable("mark");
            return p.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{mark}), (PlanNode)p.markDistinct(mark, (List<VariableReferenceExpression>)ImmutableList.of((Object)key), (PlanNode)p.values(key)));
        }).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneMarkDistinctColumns()).on(p -> {
            VariableReferenceExpression key = p.variable("key");
            VariableReferenceExpression mark = p.variable("mark");
            return p.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{key, mark}), (PlanNode)p.markDistinct(mark, (List<VariableReferenceExpression>)ImmutableList.of((Object)key), (PlanNode)p.values(key)));
        }).doesNotFire();
    }
}

